package com.thebeastshop.support.vo.cart;

import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.customize.UserSingleCustomization;

import java.io.Serializable;
import java.util.List;

/**
 * 购物车请求实例
 * Created by GFL on 2017/9/12.
 */
public class RequestPack implements Serializable {

    private static final long serialVersionUID = -6278797198649518199L;
    // 购物车id
    private Long id;
    // 商品spvid
    private Long spvId;
    // 商品数量
    private int count = 1;
    // 商品来源 @CartPackSource ，默认自购
    private CartPackSource source = CartPackSource.RAW;
    // 定制项列表
    private List<UserSingleCustomization> customizes;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public CartPackSource getSource() {
        return source;
    }

    public void setSource(CartPackSource source) {
        this.source = source;
    }

    public List<UserSingleCustomization> getCustomizes() {
        return customizes;
    }

    public void setCustomizes(List<UserSingleCustomization> customizes) {
        this.customizes = customizes;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("RequestPack{");
        sb.append("id=").append(id);
        sb.append(", spvId=").append(spvId);
        sb.append(", count=").append(count);
        sb.append(", source=").append(source);
        sb.append(", customizes=").append(customizes);
        sb.append('}');
        return sb.toString();
    }
}
