package com.thebeastshop.support.enums.flowerMonth;

/**
 * 周枚举
 * Created by feilong.gao on 2016/12/6.
 */
public enum DeliveryTimeEnum {

    MONDAY(1,"周一"),
    TUESDAY(2,"周二"),
    WEDNESDAY(3,"周三"),
    THURSDAY(4,"周四"),
    FRIDAY(5,"周五"),
    SATURDAY(6,"周六"),
    SUNDAY(7,"周日");

    private Integer code;
    private String desc;

    private DeliveryTimeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 获取奖品类型Code
     * @return
     */
    public Integer getCode() {
        return code;
    }

    /**
     * 获取奖品类型描述
     * @return
     */
    public String getDesc() {
        return desc;
    }

    /**
     * 根据Code获取描述
     * @param code
     * @return
     */
    public static String getDesc(Integer code){
        for(DeliveryTimeEnum value : DeliveryTimeEnum.values()){
            if(value.getCode().equals(code)){
                return value.getDesc();
            }
        }
        return "";
    }
}
