package com.thebeastshop.support.enums.benefit;

/**
 * 特权状态枚举
 * Created by feilong.gao on 2016/12/14.
 */
public enum BenefitStateEnum {

    /**
     * 未达成条件
     */
    PRE("PRE", "还未达成条件(无效)"),
    /**
     * 目前有效
     */
    VALID("VALID", "目前有效"),
    /**
     * 已经过期
     */
    EXPIRED("EXPIRED", "已经过期"),

    /**
     * 已经使用完
     */
    USED("USED", "已经使用完(无效)"),
    /**
     * 其他无效
     */
    INVALID("INVALID", "其他无效"),;

    private String code;

    private String desc;

    private BenefitStateEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
