package com.thebeastshop.support.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;
import com.thebeastshop.support.mark.HasName;

/**
 * 价格计算类型
 * 
 * @author Paul-xiong
 *
 */
public enum PriceType implements HasIntIdGetter, HasName {
	/**
	 * 会员折扣
	 */
	MEMBER_LEVEL(1, "会员折扣"),
	/**
	 * 活动
	 */
	CAMPAIGN(2, "活动"),
	/**
	 * 优惠券
	 */
	COUPON(3, "优惠券"),
	/**
	 * 生日折扣
	 */
	BIRTHDAY(4, "生日折扣"),
	/**
	 * 礼品卡折扣
	 */
	GIFTCARD(5, "礼品卡"),
	/**
	 * 运费
	 */
	POSTAGE(6, "运费"),
	/**
	 * 海淘运费
	 */
	OVERSEAS(7, "海淘运费"),
	/**
	 * 定制费
	 */
	CUSTOMIZE(8, "定制费"),
	/**
	 * 精确时段配送费
	 */
	TIME(9, "精确时段配送费"),
	/**
	 * 浦发兑换权益
	 */
	PSD(10, "浦发权益兑换"), ;

	public final Integer id;
	public final String name;

	public static final List<PriceType> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PriceType(final Integer id, final String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

}
