/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.exception;

import com.thebeastshop.support.exception.BaseException;
import com.thebeastshop.support.exception.PlatErrInfo;
import com.thebeastshop.support.exception.PlatProblem;
import com.thebeastshop.support.mark.Retryable;

public class PlatInternalException
extends BaseException
implements PlatProblem,
Retryable {
    public static final String DEFAULT_MSG = "{PLAT_NAME_PLACEHOLDER}\u5e73\u53f0\u63a5\u53e3\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u5ba2\u670d\u3002";
    private static final long serialVersionUID = 1077946455116054913L;
    private final PlatErrInfo platErrInfo;
    private final int retryInterval;

    public PlatInternalException(PlatErrInfo platErrInfo) {
        this(platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatInternalException(PlatErrInfo platErrInfo, int retryInterval) {
        super(PlatProblem.PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo), NEXT_STEP_IDS_OF_REPORT_PROBLEM);
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatInternalException(String message, PlatErrInfo platErrInfo) {
        this(message, platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatInternalException(String message, PlatErrInfo platErrInfo, int retryInterval) {
        super(message, NEXT_STEP_IDS_OF_REPORT_PROBLEM);
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatInternalException(Throwable cause, PlatErrInfo platErrInfo) {
        this(PlatProblem.PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo), cause, platErrInfo);
    }

    public PlatInternalException(String message, Throwable cause, PlatErrInfo platErrInfo) {
        this(message, cause, platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatInternalException(String message, Throwable cause, PlatErrInfo platErrInfo, int retryInterval) {
        super(message, cause, NEXT_STEP_IDS_OF_REPORT_PROBLEM);
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatInternalException(Throwable cause, PlatErrInfo platErrInfo, int retryInterval) {
        this(PlatProblem.PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo), cause, platErrInfo, retryInterval);
    }

    @Override
    public int getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.hashCode() + ":{" + "retryInterval:" + this.retryInterval + ", platName:'" + this.getPlatName() + '\'' + ", platErrCode:'" + this.getPlatErrCode() + '\'' + ", platErrMsg:'" + this.getPlatErrMsg() + '\'' + '}';
    }

    @Override
    public String getPlatName() {
        return this.platErrInfo.getPlatName();
    }

    @Override
    public String getPlatErrCode() {
        return this.platErrInfo.getPlatErrCode();
    }

    @Override
    public String getPlatErrMsg() {
        return this.platErrInfo.getPlatErrMsg();
    }

    @Override
    public int getMaxRetryTimes() {
        return 1;
    }
}

