package com.thebeastshop.support.vo.stock;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 线下店铺库存
 * @Class Name StoreStockVO
 * @Author Xiang.Gao
 * @Create In 2017-9-19
 */
public class StoreStockVO {

	/**
	 * 渠道编号
	 * @Field String channelCode 
	 */
	private String channelCode;
	
	/**
	 * 渠道名称
	 * @Field String channelName 
	 */
	private String channelName;
	
	/**
	 * 可用库存量
	 * @Field Integer quantity 
	 */
	private Integer quantity;
	
	public StoreStockVO() {
		super();
	}

	public StoreStockVO(String channelCode, String channelName, Integer quantity) {
		super();
		this.channelCode = channelCode;
		this.channelName = channelName;
		this.quantity = quantity;
	}

	public String getChannelCode() {
		return channelCode;
	}

	public void setChannelCode(String channelCode) {
		this.channelCode = channelCode;
	}

	public String getChannelName() {
		return channelName;
	}

	public void setChannelName(String channelName) {
		this.channelName = channelName;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
	}
	
}
