package com.thebeastshop.support.vo.product;

import java.io.Serializable;
import java.util.Date;

/**
 * @author feilong.gao
 * @Date 2018/7/9 11:27.
 * @Description 商品活动信息
 */
public class ProductCampaignVO implements Serializable{

    private static final long serialVersionUID = -5523426383765797228L;
    private String name;                  // String 活动名字
    private String discountType;          // enum.<PRICE_DISCOUNT|FULL_CUT|FULL_GIFT|CHEAPEN_OTHER|FULL_DISCOUNT|PANIC_BUY|OPTION> 折扣类型价格折扣|满减|满赠|换购|满折|抢购|N元任选 目前服务端只返回价格折扣,和抢购活动信息
    private Boolean preview;            // Boolean 是否预告
    private Date bgTime;                  // timestamp 活动开始时间
    private Date edTime;                  // timestamp 活动结束时间
    private Integer limit;                //活动剩余数量

    public ProductCampaignVO(String name, String discountType, Boolean preview, Date bgTime, Date edTime, Integer limit) {
        this.name = name;
        this.discountType = discountType;
        this.preview = preview;
        this.bgTime = bgTime;
        this.edTime = edTime;
        this.limit = limit;
    }

    public ProductCampaignVO() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDiscountType() {
        return discountType;
    }

    public void setDiscountType(String discountType) {
        this.discountType = discountType;
    }

    public Boolean getPreview() {
        return preview;
    }

    public void setPreview(Boolean preview) {
        preview = preview;
    }

    public Date getBgTime() {
        return bgTime;
    }

    public void setBgTime(Date bgTime) {
        this.bgTime = bgTime;
    }

    public Date getEdTime() {
        return edTime;
    }

    public void setEdTime(Date edTime) {
        this.edTime = edTime;
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("ProductCampaignVO{");
        sb.append("name='").append(name).append('\'');
        sb.append(", discountType='").append(discountType).append('\'');
        sb.append(", preview=").append(preview);
        sb.append(", bgTime=").append(bgTime);
        sb.append(", edTime=").append(edTime);
        sb.append(", limit=").append(limit);
        sb.append('}');
        return sb.toString();
    }
}
