package com.thebeastshop.support.vo.product;

import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.support.Label;
import com.thebeastshop.support.vo.product.SimpleProductVO.DiscVO;
import com.thebeastshop.support.vo.product.SpvVO.BrandVO;

/**
 * 圣诞集赞商品 Created by WangYawei on 2017/12/07.
 */

public class ChristmasProductVO {

	private SimpleProductVO raw = new SimpleProductVO();

	/**
	 * 规格
	 */
	private ProductVariantVO variant = new ProductVariantVO();

	/**
	 * 集赞价
	 */
	private String christmasPrice;

	/**
	 * 描述
	 */
	private String christmasDesc;

	/**
	 * 库存
	 */
	private Integer christmasStock;

	public ChristmasProductVO() {
		super();
	}

	public ChristmasProductVO(SimpleProductVO raw) {
		this.raw = raw;
	}

	public Boolean getForetell() {
		return raw.getForetell();
	}

	public void setForetell(Boolean foretell) {
		raw.setForetell(foretell);
	}

	public Boolean getIsOversea() {
		return raw.getIsOversea();
	}

	public void setIsOversea(Boolean isOversea) {
		raw.setIsOversea(isOversea);
	}

	public Boolean getCustomizable() {
		return raw.getCustomizable();
	}

	public void setCustomizable(Boolean customizable) {
		raw.setCustomizable(customizable);
	}

	public DiscVO getDiscount() {
		return raw.getDiscount();
	}

	public void setDiscount(DiscVO discount) {
		raw.setDiscount(discount);
	}

	public String getFeatureImage() {
		return raw.getFeatureImage();
	}

	public void setFeatureImage(String featureImage) {
		raw.setFeatureImage(featureImage);
	}

	public String getId() {
		return raw.getId();
	}

	public BrandVO getBrand() {
		return raw.getBrand();
	}

	public String getName() {
		return raw.getName();
	}

	public String getSummary() {
		return raw.getSummary();
	}

	public BigDecimal getRawPrice() {
		return raw.getRawPrice();
	}

	public BigDecimal getPrice() {
		return raw.getPrice();
	}

	public Boolean getSoldOut() {
		return raw.getSoldOut();
	}

	public Boolean getInvisible() {
		return raw.getInvisible();
	}

	public void setInvisible(Boolean invisible) {
		raw.setInvisible(invisible);
	}

	public Boolean getOffShelf() {
		return raw.getOffShelf();
	}

	public void setOffShelf(Boolean offShelf) {
		raw.setOffShelf(offShelf);
	}

	public List<Label> getLabels() {
		return raw.getLabels();
	}

	public void setLabels(List<Label> labels) {
		raw.setLabels(labels);
	}

	public ProductVariantVO getVariant() {
		return variant;
	}

	public void setId(String id) {
		raw.setId(id);
	}

	public List<String> getImages() {
		return raw.getImages();
	}

	public void setImages(List<String> images) {
		raw.setImages(images);
	}

	public void setBrand(BrandVO brand) {
		raw.setBrand(brand);
	}

	public void setName(String name) {
		raw.setName(name);
	}

	public void setSummary(String summary) {
		raw.setSummary(summary);
	}

	public void setRawPrice(BigDecimal rawPrice) {
		raw.setRawPrice(rawPrice);
	}

	public void setPrice(BigDecimal price) {
		raw.setPrice(price);
	}

	public void setSoldOut(Boolean soldOut) {
		raw.setSoldOut(soldOut);
	}

	public void setVariant(ProductVariantVO variant) {
		this.variant = variant;
	}

	public SimpleProductVO getRaw() {
		return raw;
	}

	public void setRaw(SimpleProductVO raw) {
		this.raw = raw;
	}

	public String getChristmasPrice() {
		return christmasPrice;
	}

	public void setChristmasPrice(String christmasPrice) {
		this.christmasPrice = christmasPrice;
	}

	public String getChristmasDesc() {
		return christmasDesc;
	}

	public void setChristmasDesc(String christmasDesc) {
		this.christmasDesc = christmasDesc;
	}

	public Integer getChristmasStock() {
		return christmasStock;
	}

	public void setChristmasStock(Integer christmasStock) {
		this.christmasStock = christmasStock;
	}

	@Override
	public String toString() {
		final StringBuffer sb = new StringBuffer("ChristmasProductVO{");
		sb.append("raw=").append(raw);
		sb.append(", variant=").append(variant);
		sb.append(", christmasPrice=").append(christmasPrice);
		sb.append(", christmasDesc=").append(christmasDesc);
		sb.append(", christmasStock=").append(christmasStock);
		sb.append('}');
		return sb.toString();
	}
}
