package com.thebeastshop.support.vo.payment;

import java.math.BigDecimal;

import com.thebeastshop.support.enums.PaymentType;

/**
 * 门店支付VO
 * @Class Name StorePaymentVO
 * @Author Xiang.Gao
 * @Create In 2017-9-19
 */
public class StorePaymentVO {

	/**
	 * 订单号
	 * @Field String orderNo 
	 */
	private String orderNo;
	
	/**
	 * 支付方式
	 * @Field PaymentType paymentType 
	 */
	private PaymentType paymentType;
	
	/**
	 * 卡号
	 * @Field String cardNo 
	 */
	private String cardNo;
	
	/**
	 * 交易参考号
	 * @Field String tradeNo 
	 */
	private String tradeNo;
	
	/**
	 * 二维码
	 * @Field String authCode 
	 */
	private String authCode;
	
	/**
	 * 密码
	 * @Field String password 
	 */
	private String password;
	
	/**
	 * 支付金额
	 * @Field BigDecimal totalAmount 
	 */
	private BigDecimal totalAmount;

	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public PaymentType getPaymentType() {
		return paymentType;
	}

	public void setPaymentType(PaymentType paymentType) {
		this.paymentType = paymentType;
	}

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}
	
	public String getTradeNo() {
		return tradeNo;
	}

	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

	public String getAuthCode() {
		return authCode;
	}

	public void setAuthCode(String authCode) {
		this.authCode = authCode;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public BigDecimal getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(BigDecimal totalAmount) {
		this.totalAmount = totalAmount;
	}

	@Override
	public String toString() {
		return "StorePaymentVO [orderNo=" + orderNo + ", paymentType="
				+ paymentType + ", cardNo=" + cardNo + ", authCode=" + authCode
				+ ", password=" + password + ", totalAmount=" + totalAmount
				+ "]";
	}

}
