package com.thebeastshop.support.vo.order;

import java.util.List;

import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.market.MarketVipDTO;

/**
 * 预览订单DTO
 * 
 * @author Paul-xiong
 *
 */
public class OrderPreviewDTO {
	/**
	 * 购物车商品包列表
	 */
	private List<RequestPack> packs;

	/**
	 * 是否使用生日折扣
	 */
	private Boolean useBdayDiscount;

	/**
	 * 地址id
	 */
	private long addressId;
	/**
	 * 配送日期
	 */
	private String deliveryDate;
	/**
	 * 配送时段
	 */
	private int deliveryTimeSlot;
	
	private String deliveryTime;
	/**
	 * 优惠券id
	 */
	private Long couponId;
	
	/**
	 * 礼品卡
	 */
	private List<GiftCardVO> giftCards;

	/**
	 * IPOS 运费
	 */
	private PostageVO postage;
	
	/**
	 * 商场VIP
	 */
	private MarketVipDTO marketVip;
	
	/**
	 * 订单业务类型
	 */
	private OrderBusinessType orderType = OrderBusinessType.NORMAL;

	public List<RequestPack> getPacks() {
		return packs;
	}

	public void setPacks(List<RequestPack> packs) {
		this.packs = packs;
	}

	public Boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(Boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}

	public long getAddressId() {
		return addressId;
	}

	public void setAddressId(long addressId) {
		this.addressId = addressId;
	}

	public String getDeliveryDate() {
		return deliveryDate;
	}

	public void setDeliveryDate(String deliveryDate) {
		this.deliveryDate = deliveryDate;
	}

	public int getDeliveryTimeSlot() {
		return deliveryTimeSlot;
	}

	public void setDeliveryTimeSlot(int deliveryTimeSlot) {
		this.deliveryTimeSlot = deliveryTimeSlot;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public List<GiftCardVO> getGiftCards() {
		return giftCards;
	}

	public void setGiftCards(List<GiftCardVO> giftCards) {
		this.giftCards = giftCards;
	}

	public PostageVO getPostage() {
		return postage;
	}

	public void setPostage(PostageVO postage) {
		this.postage = postage;
	}

	public String getDeliveryTime() {
		return deliveryTime;
	}

	public void setDeliveryTime(String deliveryTime) {
		this.deliveryTime = deliveryTime;
	}

	public MarketVipDTO getMarketVip() {
		return marketVip;
	}

	public void setMarketVip(MarketVipDTO marketVip) {
		this.marketVip = marketVip;
	}

	public OrderBusinessType getOrderType() {
		return orderType;
	}

	public void setOrderType(OrderBusinessType orderType) {
		this.orderType = orderType;
	}
	
	
}
