package com.thebeastshop.support.vo.order;

import java.util.Collection;

import com.thebeastshop.support.vo.logistics.LogisticsBasicVO;

/**
 * 订单包裹
 * 
 * @author Paul-xiong
 *
 */
public class OrderParcelVO {
	/**
	 * 物流信息
	 */
	private LogisticsBasicVO logistics;
	/**
	 * 商品包
	 */
	private Collection<OrderProductPackVO> packs;
	/**
	 * 包裹状态
	 */
	private OrderParcelStateVO state;
    /**
     * 配送日期
     */
	private String sendDate;
	/**
	 * 收货日期
	 */
	private String receiveDate;
	/**
	 * 是否高亮
	 */
	private boolean highlight=false;
	
	
	
	public boolean isHighlight() {
		return highlight;
	}

	public void setHighlight(boolean highlight) {
		this.highlight = highlight;
	}

	public OrderParcelVO() {
		super();
	}

	public LogisticsBasicVO getLogistics() {
		return logistics;
	}

	public void setLogistics(LogisticsBasicVO logistics) {
		this.logistics = logistics;
	}

	public Collection<OrderProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(Collection<OrderProductPackVO> packs) {
		this.packs = packs;
	}

	public OrderParcelStateVO getState() {
		return state;
	}

	public void setState(OrderParcelStateVO state) {
		this.state = state;
	}

	public String getSendDate() {
		return sendDate;
	}

	public void setSendDate(String sendDate) {
		this.sendDate = sendDate;
	}

	public String getReceiveDate() {
		return receiveDate;
	}

	public void setReceiveDate(String receiveDate) {
		this.receiveDate = receiveDate;
	}

	@Override
	public String toString() {
		return "OrderParcelVO [logistics=" + logistics + ", packs=" + packs + ", state=" + state + "]";
	}

	/**
	 * 包裹状态
	 * 
	 * @author Paul-xiong
	 *
	 */
	public static class OrderParcelStateVO {
		/**
		 * 枚举名
		 */
		private String type;
		/**
		 * 描述
		 */
		private String desc;

		public String getType() {
			return type;
		}

		public void setType(String type) {
			this.type = type;
		}

		public String getDesc() {
			return desc;
		}

		public void setDesc(String desc) {
			this.desc = desc;
		}

		@Override
		public String toString() {
			return "OrderParcelStateVO [type=" + type + ", desc=" + desc + "]";
		}

	}

}
