package com.thebeastshop.support.vo.order;

import com.thebeastshop.support.enums.OrderCardType;

import java.io.Serializable;

/**
 * 订单卡片
 * Created by feilong.gao on 2017/5/9.
 */
public class OrderCard implements Serializable {
    private static final long serialVersionUID = -1502658380540826583L;

    /**
     * 卡片类型，0不需要1空白2代写
     */
    private OrderCardType type = OrderCardType.NONE;

    /**
     * 卡片抬头信息
     */
    private String to;
    /**
     * 卡片正文
     */
    private String content;

    /**
     * 卡片落款信息
     */
    private String from;


    public OrderCardType getType() {
        return type;
    }

    public void setType(OrderCardType type) {
        this.type = type;
    }

    public String getTo() {
        return to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("OrderCard{");
        sb.append("type=").append(type);
        sb.append(", to='").append(to).append('\'');
        sb.append(", content='").append(content).append('\'');
        sb.append(", from='").append(from).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
