package com.thebeastshop.support.vo.member;

public class MemberAddressVO {

	private Long id;
	/**
	 * 收件人
	 */
	private String receiverName;
	/**
	 * 收件人手机号
	 */
	private String receiverPhone;
	/**
	 * 是否为默认地址
	 */
	private boolean asDefault;
	/**
	 * 详细地址
	 */
	private String location;
	/**
	 * 邮编
	 */
	private String zipCode;
	/**
	 * 区域
	 */
	private DistrictVO district;
	/**
	 * 区域
	 */
	private RingVO ring;
	/**
	 * 是否验证过身份证
	 */
	private boolean idCardValidated = false;
	/**
	 * 是否上传过身份证图片
	 */
	private boolean idCardPhotoUploaded = false;

	public MemberAddressVO() {
		super();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getReceiverName() {
		return receiverName;
	}

	public void setReceiverName(String receiverName) {
		this.receiverName = receiverName;
	}

	public String getReceiverPhone() {
		return receiverPhone;
	}

	public void setReceiverPhone(String receiverPhone) {
		this.receiverPhone = receiverPhone;
	}

	public boolean isAsDefault() {
		return asDefault;
	}

	public void setAsDefault(boolean asDefault) {
		this.asDefault = asDefault;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	public DistrictVO getDistrict() {
		return district;
	}

	public void setDistrict(DistrictVO district) {
		this.district = district;
	}

	public boolean isIdCardValidated() {
		return idCardValidated;
	}

	public void setIdCardValidated(boolean idCardValidated) {
		this.idCardValidated = idCardValidated;
	}

	public boolean isIdCardPhotoUploaded() {
		return idCardPhotoUploaded;
	}

	public void setIdCardPhotoUploaded(boolean idCardPhotoUploaded) {
		this.idCardPhotoUploaded = idCardPhotoUploaded;
	}

	public RingVO getRing() {
		return ring;
	}

	public void setRing(RingVO ring) {
		this.ring = ring;
	}

	@Override
	public String toString() {
		return "MemberAddressVO [id=" + id + ", receiverName=" + receiverName + ", receiverPhone=" + receiverPhone
				+ ", asDefault=" + asDefault + ", location=" + location + ", zipCode=" + zipCode + ", district="
				+ district + ", ring=" + ring + ", idCardValidated=" + idCardValidated + ", idCardPhotoUploaded="
				+ idCardPhotoUploaded + "]";
	}

	/**
	 * 区域
	 * 
	 * @author Paul-xiong
	 *
	 */
	public static class DistrictVO {
		/**
		 * id
		 */
		private Long id;
		/**
		 * 区域名
		 */
		private String name;
		/**
		 * 区域全称
		 */
		private String fullName;

		public Long getId() {
			return id;
		}

		public void setId(Long id) {
			this.id = id;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getFullName() {
			return fullName;
		}

		public void setFullName(String fullName) {
			this.fullName = fullName;
		}

		@Override
		public String toString() {
			return "District [id=" + id + ", name=" + name + ", fullName=" + fullName + "]";
		}

	}

	/**
	 * 环线
	 * 
	 * @author Paul-xiong
	 *
	 */
	public static class RingVO {
		/**
		 * id
		 */
		private Long id;
		/**
		 * 环线名
		 */
		private String name;

		public Long getId() {
			return id;
		}

		public void setId(Long id) {
			this.id = id;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		@Override
		public String toString() {
			return "RingVO [id=" + id + ", name=" + name + "]";
		}

	}

}
