package com.thebeastshop.support.vo.coupon;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.thebeastshop.support.mark.Type;

public class CouponVO implements Serializable {
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private Long id;
	private CouponTypeVO type = CouponTypeVO.COUPON;
	private String title;
	private String description;
	private Date startTime;
	private Date createTime;
	private Date expireTime;
	private String productDesc;
	private BigDecimal threshold;
	private String thresholdDesc;
	private BigDecimal discount;
	private BigDecimal discountRatio;
	private String note;
	private Boolean used;
	private Boolean usable;
	private Boolean expired;
	private String code;
	private String partnerLogo;
	private String deeplink;
	
	/**
	 * 图标
	 */
	//private String icon;

	/**
	 * 关键字
	 */
	private String tag;
	/**
	 * 优惠卷类型
	 */
	private DiscountType discountType = DiscountType.CHEAPEN_LINE;
	
	/**
	 * 默认选中
	 */
	private boolean defaultSelect;

	public BigDecimal getDiscountRatio() {
		return discountRatio;
	}

	public void setDiscountRatio(BigDecimal discountRatio) {
		this.discountRatio = discountRatio;
	}

	public String getDeeplink() {
		return deeplink;
	}

	public void setDeeplink(String deeplink) {
		this.deeplink = deeplink;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public Date getExpireTime() {
		return expireTime;
	}

	public void setExpireTime(Date expireTime) {
		this.expireTime = expireTime;
	}

	public String getProductDesc() {
		return productDesc;
	}

	public void setProductDesc(String productDesc) {
		this.productDesc = productDesc;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Boolean getUsed() {
		return used;
	}

	public void setUsed(Boolean used) {
		this.used = used;
	}

	public Boolean getUsable() {
		return usable;
	}

	public void setUsable(Boolean usable) {
		this.usable = usable;
	}

	public Boolean getExpired() {
		return expired;
	}

	public void setExpired(Boolean expired) {
		this.expired = expired;
	}

	public CouponTypeVO getType() {
		return type;
	}

	public void setType(CouponTypeVO type) {
		this.type = type;
	}

	public BigDecimal getThreshold() {
		return threshold;
	}

	public void setThreshold(BigDecimal threshold) {
		this.threshold = threshold;
	}

	public String getThresholdDesc() {
		return thresholdDesc;
	}

	public void setThresholdDesc(String thresholdDesc) {
		this.thresholdDesc = thresholdDesc;
	}

	public BigDecimal getDiscount() {
		return discount;
	}

	public void setDiscount(BigDecimal discount) {
		this.discount = discount;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getPartnerLogo() {
		return partnerLogo;
	}

	public void setPartnerLogo(String partnerLogo) {
		this.partnerLogo = partnerLogo;
	}
	
	

//	public String getIcon() {
//		return icon;
//	}
//
//	public void setIcon(String icon) {
//		this.icon = icon;
//	}


	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public DiscountType getDiscountType() {
		return discountType;
	}

	public void setDiscountType(DiscountType discountType) {
		this.discountType = discountType;
	}

	public boolean isDefaultSelect() {
		return defaultSelect;
	}

	public void setDefaultSelect(boolean defaultSelect) {
		this.defaultSelect = defaultSelect;
	}

	@Override
	public String toString() {
		final StringBuffer sb = new StringBuffer("CouponVO{");
		sb.append("id=").append(id);
		sb.append(", type=").append(type);
		sb.append(", title='").append(title).append('\'');
		sb.append(", description='").append(description).append('\'');
		sb.append(", startTime=").append(startTime);
		sb.append(", createTime=").append(createTime);
		sb.append(", expireTime=").append(expireTime);
		sb.append(", productDesc='").append(productDesc).append('\'');
		sb.append(", threshold=").append(threshold);
		sb.append(", thresholdDesc='").append(thresholdDesc).append('\'');
		sb.append(", discount=").append(discount);
		sb.append(", note='").append(note).append('\'');
		sb.append(", used=").append(used);
		sb.append(", usable=").append(usable);
		sb.append(", expired=").append(expired);
		sb.append(", code='").append(code).append('\'');
		sb.append(", partnerLogo='").append(partnerLogo).append('\'');
		sb.append(", discountRatio='").append(discountRatio).append('\'');
		sb.append('}');
		return sb.toString();
	}

	public static enum CouponTypeVO implements Type, Serializable {
		COUPON(0, "优惠券"), CARD(1, "卡券"), OFFLINE(2, "线下优惠券"), GENERAL(3, "通用优惠券");

		public final int id;
		public final String name;

		private CouponTypeVO(int id, String name) {
			this.id = id;
			this.name = name;
		}

		@Override
		public Integer getId() {
			return id;
		}

		@Override
		public String getName() {
			return name;
		}
	}

	
	public static enum DiscountType {

	    CHEAPEN_LINE(1, "满减"),
	    DISCOUNT_LINE(2, "折扣"),
	    FIXEDPRICE_LINE(3, "定价")
	    ;

	    private final int id;

	    private final String name;

	    public static final List<DiscountType> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	    DiscountType(int id, String name) {
	        this.id = id;
	        this.name = name;
	    }

	    public int getId() {
	        return id;
	    }

	    public String getName() {
	        return name;
	    }

	    public static DiscountType getById(int id) {
	        for (DiscountType e : DiscountType.values()) {
	            if (e.getId() == id) {
	                return e;
	            }
	        }
	        return null;
	    }
	}
}
