package com.thebeastshop.support.vo.cart;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

import com.google.common.collect.Lists;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.customize.UserSingleCustomization;
import com.thebeastshop.support.vo.product.SpvVO;

/**
 * 商品包
 * 
 * @author Paul-xiong
 *
 */
public class CartProductPackVO implements Serializable {
	/**
	 *
	 */
	private static final long serialVersionUID = 7949689391932894329L;
	/**
	 * 
	 */
	private Long id;
	/**
	 * 数量
	 */
	private int count = 1;
	/**
	 * 商品包来源
	 */
	private CartPackSource source = CartPackSource.RAW;
	/**
	 * 商品code
	 */
	private String productId;
	/**
	 * spv信息
	 */
	private SpvVO spv;
	/**
	 * 是否包含规格
	 */
	private boolean hasVariants;
	/**
	 * 标签
	 */
	private Collection<Label> labels = Lists.newArrayList();
	/**
	 * 赠品商品
	 */
	private List<CartProductPackVO> giftPacks;
	/**
	 * 是否已获得（加价购才有）
	 */
	private Boolean owned = false;
	
	/**
	 * 是否定制商品
	 */
	private Boolean customizable = false;
	
	/**
	 * 该商品用户是否已经定制过，若定制过，则不允许用户再修改 spv 信息
	 */
	private Boolean customized = false;
	/**
	 * 定制内容
	 */
	private String customizeInfo;
	/**
	 * 定制属性集
	 */
	private List<UserSingleCustomization> customizes;
	/**
	 * 权益对象
	 */
	private CartBenefitVO benefit;
	/**
	 * 参加的赠品活动
	 */
	private PackCampaignVO campaign;

	/**
	 *
	 */
	private InvalidVO invalid = new InvalidVO();

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}

	public CartPackSource getSource() {
		return source;
	}

	public void setSource(CartPackSource source) {
		this.source = source;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public SpvVO getSpv() {
		return spv;
	}

	public void setSpv(SpvVO spv) {
		this.spv = spv;
	}

	public boolean isHasVariants() {
		return hasVariants;
	}

	public void setHasVariants(boolean hasVariants) {
		this.hasVariants = hasVariants;
	}

	public Collection<Label> getLabels() {
		return labels;
	}

	public void setLabels(Collection<Label> labels) {
		this.labels = labels;
	}

	public List<CartProductPackVO> getGiftPacks() {
		return giftPacks;
	}

	public void setGiftPacks(List<CartProductPackVO> giftPacks) {
		this.giftPacks = giftPacks;
	}

	public Boolean getOwned() {
		return owned;
	}

	public void setOwned(Boolean owned) {
		this.owned = owned;
	}
	
	public Boolean getCustomizable() {
		return customizable;
	}

	public void setCustomizable(Boolean customizable) {
		this.customizable = customizable;
	}

	public Boolean getCustomized() {
		return customized;
	}

	public void setCustomized(Boolean customized) {
		this.customized = customized;
	}

	public String getCustomizeInfo() {
		return customizeInfo;
	}

	public void setCustomizeInfo(String customizeInfo) {
		this.customizeInfo = customizeInfo;
	}

	public List<UserSingleCustomization> getCustomizes() {
		return customizes;
	}

	public void setCustomizes(List<UserSingleCustomization> customizes) {
		this.customizes = customizes;
	}

	public CartBenefitVO getBenefit() {
		return benefit;
	}

	public void setBenefit(CartBenefitVO benefit) {
		this.benefit = benefit;
	}

	public PackCampaignVO getCampaign() {
		return campaign;
	}

	public void setCampaign(PackCampaignVO campaign) {
		this.campaign = campaign;
	}

	public InvalidVO getInvalid() {
		return invalid;
	}

	public void setInvalid(InvalidVO invalid) {
		this.invalid = invalid;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder("CartProductPackVO{");
		sb.append("id=").append(id);
		sb.append(", count=").append(count);
		sb.append(", source=").append(source);
		sb.append(", productId='").append(productId).append('\'');
		sb.append(", spv=").append(spv);
		sb.append(", hasVariants=").append(hasVariants);
		sb.append(", labels=").append(labels);
		sb.append(", giftPacks=").append(giftPacks);
		sb.append(", owned=").append(owned);
		sb.append(", customized=").append(customized);
		sb.append(", customizeInfo='").append(customizeInfo).append('\'');
		sb.append(", customizes=").append(customizes);
		sb.append(", benefit=").append(benefit);
		sb.append(", campaign=").append(campaign);
		sb.append('}');
		return sb.toString();
	}

	public static class PackCampaignVO implements Serializable {

		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		private Long id;

		private InfoVO info;

		private String name;

		public Long getId() {
			return id;
		}

		public void setId(Long id) {
			this.id = id;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public InfoVO getInfo() {
			return info;
		}

		public void setInfo(InfoVO info) {
			this.info = info;
		}

		public static class InfoVO implements Serializable {

			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;

			private String type;

			private String typeColor = "#FFFFFF";

			private String typeBgColor = "#537371";

			private String summaryColor = "#000000";

			public String getType() {
				return type;
			}

			public void setType(String type) {
				this.type = type;
			}

			public String getTypeColor() {
				return typeColor;
			}

			public void setTypeColor(String typeColor) {
				this.typeColor = typeColor;
			}

			public String getTypeBgColor() {
				return typeBgColor;
			}

			public void setTypeBgColor(String typeBgColor) {
				this.typeBgColor = typeBgColor;
			}

			public String getSummaryColor() {
				return summaryColor;
			}

			public void setSummaryColor(String summaryColor) {
				this.summaryColor = summaryColor;
			}

		}

	}

	public static class InvalidVO implements Serializable{

		private Boolean invalid = false;

		private String desc;

		public Boolean getInvalid() {
			return invalid;
		}

		public void setInvalid(Boolean invalid) {
			this.invalid = invalid;
		}

		public String getDesc() {
			return desc;
		}

		public void setDesc(String desc) {
			this.desc = desc;
		}
	}
}
