/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

/**
 * Bean工具类
 * 
 * @author Paul-xiong
 *
 */
public class BeanUtil {

	/**
	 * 将map转换为bean
	 * 
	 * @param map
	 *            map集合
	 * @param clazz
	 *            bean对象
	 * @return
	 * @throws Exception
	 */
	public static <T> T map2Bean(Map<String, ?> map, Class<T> clazz) throws Exception {
		T t = clazz.newInstance();

		BeanInfo beanInfo = Introspector.getBeanInfo(t.getClass());
		PropertyDescriptor[] propertys = beanInfo.getPropertyDescriptors();

		for (PropertyDescriptor property : propertys) {
			String key = property.getName();
			if (map.containsKey(key)) {
				Object value = map.get(key);
				// 得到property对应的setter方法
				Method setter = property.getWriteMethod();
				setter.invoke(t, value);
			}
		}

		return t;
	}

	/**
	 * 将bean转换为map
	 * 
	 * @param obj
	 *            bean对象
	 * @return
	 * @throws Exception
	 */
	public static Map<String, Object> bean2Map(Object obj) throws Exception {
		Map<String, Object> map = new HashMap<String, Object>();
		Set<Field> fields = new HashSet<Field>();
		Class<?> clazz = obj.getClass();
		for (; clazz != Object.class; clazz = clazz.getSuperclass()) {
			fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
		}
		for (Field field : fields) {
			field.setAccessible(true);
			map.put(field.getName(), field.get(obj));
		}
		return map;
	}

	/**
	 *
	 * @param src
	 *            源bean
	 * @param clz
	 *            目标bean class
	 * @return
	 */
	public static <T> T buildFrom(T src, Class<T> clz) {
		return buildFrom(src, clz, null);
	}

	/**
	 *
	 * @param src
	 *            源bean
	 * @param clz
	 *            目标bean class
	 * @param ignoreProperties
	 *            忽略的属性
	 * @return
	 */
	public static <T> T buildFrom(T src, Class<T> clz, String[] ignoreProperties) {
		if (src == null)
			return null;
		T obj = null;
		try {
			obj = clz.newInstance();
			BeanUtils.copyProperties(src, obj, ignoreProperties);
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		return obj;
	}

	/**
	 *
	 * @param src
	 *            源bean
	 * @param clz
	 *            目标bean class
	 * @return
	 */
	public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz) {
		return buildListFrom(src, clz, null);
	}

	/**
	 *
	 * @param src
	 *            源bean
	 * @param clz
	 *            目标bean class
	 * @param ignoreProperties
	 *            忽略的属性
	 * @return
	 */
	public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz, String[] ignoreProperties) {
		if (CollectionUtils.isEmpty(src))
			return Collections.emptyList();

		List<T> objs = new ArrayList<T>(src.size());
		try {
			for (Object o : src) {
				T obj = clz.newInstance();
				BeanUtils.copyProperties(o, obj, ignoreProperties);
				objs.add(obj);
			}
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		return objs;
	}

}
