package com.thebeastshop.support.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

/**
 * 动态代理工具类
 *
 * @author Liang Wenjian
 */
public class ProxyUtil {

    @SuppressWarnings("unchecked")
    public static <T> T newProxyInstance(final InvocationHandler h, final Class<?> interfaceToImplement) {
        return newProxyInstance(h, new Class<?>[]{interfaceToImplement});
    }

    public static <T> T newProxyInstance(final ClassLoader loader, final InvocationHandler h,
                                            final Class<?> interfaceToImplement) {
        return newProxyInstance(loader, h, new Class<?>[]{interfaceToImplement});
    }

    public static <T> T newProxyInstance(final InvocationHandler h, final Class<?>... interfaces) {
        return newProxyInstance(h.getClass()
                                 .getClassLoader(), h, interfaces);
    }

    @SuppressWarnings("unchecked")
    public static <T> T newProxyInstance(final ClassLoader loader, final InvocationHandler h,
                                            final Class<?>... interfaces) {
        return (T) Proxy.newProxyInstance(loader, interfaces, h);
    }

    private ProxyUtil() {
        super();
    }
}
