package com.thebeastshop.support.mark;

/**
 * 实现此接口的类，表示拥有deletable（可删除）属性。
 *
 * @author Liang Wenjian
 */
public interface Deletable {
    String PROPERTY_NAME = "deletable";

    /**
     * 是否可删除。对于不可删除的对象，使用者不应进行删除请求；处理者也应该对删除请求进行相应的判断。
     *
     * @return true表示可以删除，false表示不可删除。
     */
    boolean getDeletable();
}
