package com.thebeastshop.support.mark;

import java.util.Objects;

/**
 * @author Liang Wenjian
 */
public class DefaultStateImpl implements State {
    private Integer id;
    private String name;

    public DefaultStateImpl() {
        super();
    }

    public DefaultStateImpl(final Integer id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    public void setId(final Integer id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State that = (State) o;
        return Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + hashCode() + ":{" +
                "id:" + id +
                ", name:'" + name + '\'' +
                '}';
    }

}
