package com.thebeastshop.support.exception;

/**
 * 电商平台api返回403响应时应抛出的异常。
 *
 * @author Liang Wenjian
 */
public class PlatForbiddenException extends BaseException implements PlatProblem {
    public static final String DEFAULT_MSG = PlatProblemUtil.PLAT_NAME_PLACEHOLDER + "平台禁止了此次请求，请联系客服。";

    private static final long serialVersionUID = 6834022964010264857L;

    private final PlatErrInfo platErrInfo;

    //----------------------------------------------------

    public PlatForbiddenException(final PlatErrInfo platErrInfo) {
        super(PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo), NEXT_STEP_IDS_OF_PLAT_AUTHORIZE);
        this.platErrInfo = platErrInfo;
    }

    public PlatForbiddenException(final String message, final PlatErrInfo platErrInfo) {
        super(message, NEXT_STEP_IDS_OF_PLAT_AUTHORIZE);
        this.platErrInfo = platErrInfo;
    }

    public PlatForbiddenException(final Throwable cause, final PlatErrInfo platErrInfo) {
        this(PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo), cause, platErrInfo);
    }

    public PlatForbiddenException(final String message, final Throwable cause, final PlatErrInfo platErrInfo) {
        super(message, cause, NEXT_STEP_IDS_OF_PLAT_AUTHORIZE);
        this.platErrInfo = platErrInfo;
    }

    //----------------------------------------------------

    @Override
    public String toString() {
        return getClass().getSimpleName() + hashCode() + ":{" +
                   "platName:'" + getPlatName() + '\'' +
                   ", platErrCode:'" + getPlatErrCode() + '\'' +
                   ", platErrMsg:'" + getPlatErrMsg() + '\'' +
                   '}';
    }

    @Override
    public String getPlatName() {
        return platErrInfo.getPlatName();
    }

    @Override
    public String getPlatErrCode() {
        return platErrInfo.getPlatErrCode();
    }

    @Override
    public String getPlatErrMsg() {
        return platErrInfo.getPlatErrMsg();
    }
}