package com.thebeastshop.support.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;
import com.thebeastshop.support.mark.HasName;

/**
 * 商品标签属性枚举类
 * 
 */
public enum TicketType implements HasIntIdGetter,HasName {
	/**
	 * 标签
	 */
	LABEL(1, "LABEL"), ATTRIBUTE(2, "ATTRIBUTE");// 属性

	public final Integer id;
	public final String name;

	public static final List<TicketType> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	TicketType(final Integer id, final String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

}
