package com.thebeastshop.support.enums;

/**
 * 红包类型
 * Created by feilong.gao on 2016/12/6.
 */
public enum RedEnvelopeType {
    COUPON(1,"COUPON","优惠券"),
    POINT(2,"POINT","积分");

    private Integer code;
    private String value;
    private String desc;

    private RedEnvelopeType(Integer code,String value, String desc){
        this.code = code;
        this.value = value;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据Code获取描述
     * @param code
     * @return
     */
    public static RedEnvelopeType get(Integer code){
        for(RedEnvelopeType value : RedEnvelopeType.values()){
            if(value.getCode()==code){
                return value;
            }
        }
        return null;
    }

}
