package com.thebeastshop.support.enums;

/**
 * Created by feilong.gao on 2017/2/13.
 */
public enum RedEnvelopeTemplateType {

    FIXED_TEMPLATE(1,"固定红包"),
    RANDOM_TEMPLATE(2,"随机红包"),
    RANDOM_SEPARATE_TEMPLATE(3,"随机分档红包");

    private Integer code;
    private String desc;

    private RedEnvelopeTemplateType(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据Code获取描述
     * @param code
     * @return
     */
    public static RedEnvelopeTemplateType get(Integer code){
        for(RedEnvelopeTemplateType value : RedEnvelopeTemplateType.values()){
            if(value.getCode().equals(code)){
                return value;
            }
        }
        return null;
    }

}
