package com.thebeastshop.support.enums;

/**
 * Created by feilong.gao on 2017/4/16.
 */
public enum PointEventEnum {

    PERFECT("PERFECT", 60, "会员完善信息积分"),;

    private String code;
    private Integer points;
    private String desc;

    private PointEventEnum(String code, Integer points, String desc) {
        this.code = code;
        this.points = points;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public Integer getPoints() {
        return points;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 获取完善信息积分状态
     *
     * @return
     */
    public static PointEventEnum getPointEventByCode(String code) {
        for (PointEventEnum value : PointEventEnum.values()) {
            if (value.getCode() == code) {
                return value;
            }
        }
        return null;
    }
}
