package com.thebeastshop.support.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * 消息类型类型
 * 
 * @author WangYawei
 *
 */
public enum MessageType {
	ALL(0, "全部", new ArrayList<String>() {
		{
			add("03");
			add("04");
		}
	}), MEMBER(1, "会员", new ArrayList<String>() {
		{
			add("03");
		}
	}), TRANSACTION(2, "交易", new ArrayList<String>() {
		{
			add("04");
		}
	});

	private final int id;
	private final String name;
	private final List<String> type;// 对应后端基础服务

	MessageType(final int id, final String name, final List<String> type) {
		this.id = id;
		this.name = name;
		this.type = type;
	}

	public Integer getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public List<String> getType() {
		return type;
	}

}
