package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.Type;

/**
 * 热搜词类型
 * 
 * @author WangYawei
 *
 */
public enum HotKeyType implements Type {
	KEYWORD(1, "KEYWORD"), DEEPLINK(2, "DEEPLINK");

	private final int id;
	private final String name;

	HotKeyType(final int id, final String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

}
