package com.thebeastshop.support.enums;

public enum CpsChannelType {
	MORE_WHEAT("TH00001", "MORE_WHEAT", "多麦"),
	YIQIFA("TH00002", "YIQIFA", "亿起发"),
	LINKTECH("TH00003", "LINKTECH", "领克特");

	private final String code;
	private final String name;
	private final String nameCN;

	CpsChannelType(final String code, final String name, final String nameCN) {
		this.code = code;
		this.name = name;
		this.nameCN = nameCN;
	}

	public String getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	public String getNameCN() {
		return nameCN;
	}

	public static CpsChannelType getByCode(String code){
		for (CpsChannelType CpsChannelType : values()){
			if (CpsChannelType.getCode().equals(code)){
				return CpsChannelType;
			}
		}
		return null;
	}
}
