package com.thebeastshop.support.encode;

/**
 * @author Liang Wenjian
 */
public enum SizeUnits {
    BYTE(1),
    KB(BYTE),
    MB(KB),
    GB(MB),
    TB(GB),
    PB(TB);

    public final int size;

    SizeUnits(final SizeUnits littleOne) {
        size = littleOne.size * 1024;
    }

    SizeUnits(final int size) {
        this.size = size;
    }

    public int toBytes(final int num) {
        return size * num;
    }

    public int toBytes() {
        return toBytes(1);
    }

    public int toOtherSize(final int num, final SizeUnits sizeUnits) {
        return size / sizeUnits.size * num;
    }
}
