/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support;

/**
 * @author Eric.Lou
 * @version $Id: PasswordUtil.java, v 0.1 2016-05-18 下午6:38
 */
public class PasswordUtil {

    private static int MIN_LENGTH = 8;
    private static int MAX_LENGTH = 16;

    /**
     * 字符串是否包含全角或中文
     * @param str
     * @return
     */
    public static boolean checkDBCOrChinese(String str){
        if(str==null){
            throw new NullPointerException();
        }
        if( str.length() < str.getBytes().length ){
            return true;
        }else{
            return false;
        }
    }

    /**
     * 检查长度
     * @param str
     * @return
     */
    public static boolean checkLength(String str) throws Exception{
        if(str==null){
            throw new NullPointerException();
        }
        if(str.length()<MIN_LENGTH){
            throw new RuntimeException("密码长度小于"+MIN_LENGTH+"位");
        }
        if(str.length()>MAX_LENGTH){
            throw new RuntimeException("密码长度大于"+MAX_LENGTH+"位");
        }
        return true;
    }

    /**
     * 校验
     * @param str
     * @return
     * @throws Exception
     */
    public static boolean valid(String str) throws Exception{
        if(checkLength(str)){
            if(checkDBCOrChinese(str)){
                throw new RuntimeException("密码包含全角字符或者中文");
            }
        }
        return true;
    }

}
