package com.thebeastshop.support.vo.order;

import com.thebeastshop.support.vo.customize.UserSingleCustomization;

import java.util.List;

import com.thebeastshop.support.vo.cart.CartProductPackVO;

/**
 * 预览订单DTO
 * 
 * @author Paul-xiong
 *
 */
public class OrderPreviewDTO {
	/**
	 * 购物车商品包列表
	 */
	private List<CartProductPackVO> packs;
	/**
	 * 立即购买商品包
	 */
	private OrderPreviewPackDTO pack;

	/**
	 * 是否使用生日折扣
	 */
	private Boolean useBdayDiscount;

	/**
	 * 地址id
	 */
	private long addressId;
	/**
	 * 配送日期
	 */
	private String deliveryDate;
	/**
	 * 配送时段
	 */
	private int deliveryTimeSlot;
	/**
	 * 优惠券id
	 */
	private Long couponId;

	public List<CartProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(List<CartProductPackVO> packs) {
		this.packs = packs;
	}

	public OrderPreviewPackDTO getPack() {
		return pack;
	}

	public void setPack(OrderPreviewPackDTO pack) {
		this.pack = pack;
	}

	public Boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(Boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}

	public long getAddressId() {
		return addressId;
	}

	public void setAddressId(long addressId) {
		this.addressId = addressId;
	}

	public String getDeliveryDate() {
		return deliveryDate;
	}

	public void setDeliveryDate(String deliveryDate) {
		this.deliveryDate = deliveryDate;
	}

	public int getDeliveryTimeSlot() {
		return deliveryTimeSlot;
	}

	public void setDeliveryTimeSlot(int deliveryTimeSlot) {
		this.deliveryTimeSlot = deliveryTimeSlot;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	/**
	 * 立即购买商品包
	 * 
	 * @author Paul-xiong
	 *
	 */
	public static class OrderPreviewPackDTO {
		private Long spvId;
		private int count = 1;
		/**
		 * 定制内容
		 */
		private List<UserSingleCustomization> customizes;

		/**
		 * 是否月送鲜花
		 */
		private Boolean monthSend = false;

		public Long getSpvId() {
			return spvId;
		}

		public void setSpvId(Long spvId) {
			this.spvId = spvId;
		}

		public int getCount() {
			return count;
		}

		public void setCount(int count) {
			this.count = count;
		}

		public List<UserSingleCustomization> getCustomizes() {
			return customizes;
		}

		public void setCustomizes(List<UserSingleCustomization> customizes) {
			this.customizes = customizes;
		}

		public Boolean getMonthSend() {
			return monthSend;
		}

		public void setMonthSend(Boolean monthSend) {
			this.monthSend = monthSend;
		}

		@Override
		public String toString() {
			final StringBuffer sb = new StringBuffer("OrderPreviewPackDTO{");
			sb.append("spvId=").append(spvId);
			sb.append(", count=").append(count);
			sb.append(", customizes=").append(customizes);
			sb.append('}');
			return sb.toString();
		}
	}

}
