package com.thebeastshop.support.vo.order;

import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cps.CpsInfo;

/**
 * 确认订单DTO
 * 
 * @author Paul-xiong
 *
 */
public class OrderConfirmDTO {
	/**
	 * 商品包
	 */
	private List<CartProductPackVO> packs;
	/**
	 * 地址id
	 */
	private long addressId;
	/**
	 * 配送日期
	 */
	private String deliveryDate;
	/**
	 * 配送时段
	 */
	private int deliveryTimeSlot;
	/**
	 * 卡片
	 */
	private String card;
	/**
	 * 新卡片
	 */
	private OrderCard newCard;
	/**
	 * 是否为匿名购买
	 */
	private boolean anonymous = true;
	/**
	 * 是否使用生日折扣
	 */
	private boolean useBdayDiscount = false;
	/**
	 * 优惠券id
	 */
	private Long couponId;
	/**
	 * 支付金额
	 */
	private BigDecimal price;
	/**
	 * APP下载来源
	 */
	private String downloadSource;

	/**
	 * 订单备注
	 */
	private String remark;

	/**
	 * 订单业务类型
	 */
	private OrderBusinessType orderType = OrderBusinessType.NORMAL;
	/**
	 * 礼品卡描述
	 */
	private String giftCard;

	/**
	 * 礼品卡金额
	 */
	private BigDecimal giftCardPrice;
	/**
	 * 第三方
	 */
	private CpsInfo cpsInfo;
	
	/**
	 * 
	 * 配送运费
	 */
	private BigDecimal deliveryPrice;
	
    /**
     * 投入来源
     */
    private String utmSource; 

	public String getGiftCard() {
		return giftCard;
	}

	public void setGiftCard(String giftCard) {
		this.giftCard = giftCard;
	}

	public BigDecimal getGiftCardPrice() {
		return giftCardPrice;
	}

	public void setGiftCardPrice(BigDecimal giftCardPrice) {
		this.giftCardPrice = giftCardPrice;
	}

	public List<CartProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(List<CartProductPackVO> packs) {
		this.packs = packs;
	}

	public long getAddressId() {
		return addressId;
	}

	public void setAddressId(long addressId) {
		this.addressId = addressId;
	}

	public String getDeliveryDate() {
		return deliveryDate;
	}

	public void setDeliveryDate(String deliveryDate) {
		this.deliveryDate = deliveryDate;
	}

	public int getDeliveryTimeSlot() {
		return deliveryTimeSlot;
	}

	public void setDeliveryTimeSlot(int deliveryTimeSlot) {
		this.deliveryTimeSlot = deliveryTimeSlot;
	}

	public String getCard() {
		return card;
	}

	public void setCard(String card) {
		this.card = card;
	}

	public OrderCard getNewCard() {
		return newCard;
	}

	public void setNewCard(OrderCard newCard) {
		this.newCard = newCard;
	}

	public boolean isAnonymous() {
		return anonymous;
	}

	public void setAnonymous(boolean anonymous) {
		this.anonymous = anonymous;
	}

	public boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public String getDownloadSource() {
		return downloadSource;
	}

	public void setDownloadSource(String downloadSource) {
		this.downloadSource = downloadSource;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public OrderBusinessType getOrderType() {
		return orderType;
	}

	public void setOrderType(OrderBusinessType orderType) {
		this.orderType = orderType;
	}

	public CpsInfo getCpsInfo() {
		return cpsInfo;
	}

	public void setCpsInfo(CpsInfo cpsInfo) {
		this.cpsInfo = cpsInfo;
	}

	public BigDecimal getDeliveryPrice() {
		return deliveryPrice;
	}

	public void setDeliveryPrice(BigDecimal deliveryPrice) {
		this.deliveryPrice = deliveryPrice;
	}

	public String getUtmSource() {
		return utmSource;
	}

	public void setUtmSource(String utmSource) {
		this.utmSource = utmSource;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder("OrderConfirmDTO{");
		sb.append("packs=").append(packs);
		sb.append(", addressId=").append(addressId);
		sb.append(", deliveryDate='").append(deliveryDate).append('\'');
		sb.append(", deliveryTimeSlot=").append(deliveryTimeSlot);
		sb.append(", card='").append(card).append('\'');
		sb.append(", newCard=").append(newCard);
		sb.append(", anonymous=").append(anonymous);
		sb.append(", useBdayDiscount=").append(useBdayDiscount);
		sb.append(", couponId=").append(couponId);
		sb.append(", price=").append(price);
		sb.append(", downloadSource='").append(downloadSource).append('\'');
		sb.append(", remark='").append(remark).append('\'');
		sb.append(", orderType=").append(orderType);
		sb.append(", giftCard='").append(giftCard).append('\'');
		sb.append(", giftCardPrice=").append(giftCardPrice);
		sb.append(", cpsInfo=").append(cpsInfo);
		sb.append(", deliveryPrice=").append(deliveryPrice);
		sb.append(", utmSource=").append(utmSource);
		sb.append('}');
		return sb.toString();
	}
}
