package com.thebeastshop.support.vo.customize;

import com.thebeastshop.support.enums.Customize.LimitType;

import java.io.Serializable;
import java.util.List;

/**
 * 输入框限制
 * Created by GFL on 2017/5/15.
 */
public class InputLimit implements Serializable {

    private static final long serialVersionUID = 1L;

    private List<LimitType> type;                      //输入文字类型限制

    private Integer maxLength;                         //最大长度限制

    public InputLimit() {
    }

    public InputLimit(List<LimitType> types, Integer maxLength) {
        this.type = types;
        this.maxLength = maxLength;
    }

    public List<LimitType> getType() {
        return type;
    }

    public void setType(List<LimitType> type) {
        this.type = type;
    }

    public Integer getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("InputLimit{");
        sb.append("type=").append(type);
        sb.append(", maxLength=").append(maxLength);
        sb.append('}');
        return sb.toString();
    }
}
