package com.thebeastshop.support.vo.customize;

import java.io.Serializable;

/**
 * 定制属性选择类型
 * Created by feilong.gao on 2016/12/12.
 */
public class CustomChoice implements Serializable{
    /**
     * 选项名字
     */
    private String name;

    /**
     * 选项值
     */
    private String value;

    /**
     * 是否可选
     */
    private Boolean available;

    /**
     * 关联属性
     */
    private ChoiceRelevant relevant;

    public CustomChoice(){};

    public CustomChoice(String name,String value){
        this.name = name;
        this.value =value;
        this.available = true;
    }

    public CustomChoice(String name,String value,ChoiceRelevant relevant){
        this.name = name;
        this.value =value;
        this.available = true;
        this.relevant = relevant;
    }

    public CustomChoice(String name,String value,Boolean available){
        this.name = name;
        this.value =value;
        this.available = available;
    }

    public CustomChoice(String name,String value,Boolean available,ChoiceRelevant relevant){
        this.name = name;
        this.value =value;
        this.available = available;
        this.relevant = relevant;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getAvailable() {
        return available;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public ChoiceRelevant getRelevant() {
        return relevant;
    }

    public void setRelevant(ChoiceRelevant relevant) {
        this.relevant = relevant;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("CustomChoice{");
        sb.append("name='").append(name).append('\'');
        sb.append(", value='").append(value).append('\'');
        sb.append(", available=").append(available);
        sb.append(", relevant=").append(relevant);
        sb.append('}');
        return sb.toString();
    }
}
