package com.thebeastshop.support.vo.coupon;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.thebeastshop.support.mark.Type;

public class CouponVO implements Serializable {
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private Long id;
	private CouponTypeVO type = CouponTypeVO.COUPON;
	private String title;
	private String description;
	private Date startTime;
	private Date createTime;
	private Date expireTime;
	private String productDesc;
	private BigDecimal threshold;
	private String thresholdDesc;
	private BigDecimal discount;
	private BigDecimal discountRatio;
	private String note;
	private Boolean used;
	private Boolean usable;
	private Boolean expired;
	private String code;
	private String partnerLogo;
	private String deeplink;

	public BigDecimal getDiscountRatio() {
		return discountRatio;
	}

	public void setDiscountRatio(BigDecimal discountRatio) {
		this.discountRatio = discountRatio;
	}

	public String getDeeplink() {
		return deeplink;
	}

	public void setDeeplink(String deeplink) {
		this.deeplink = deeplink;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public Date getExpireTime() {
		return expireTime;
	}

	public void setExpireTime(Date expireTime) {
		this.expireTime = expireTime;
	}

	public String getProductDesc() {
		return productDesc;
	}

	public void setProductDesc(String productDesc) {
		this.productDesc = productDesc;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Boolean getUsed() {
		return used;
	}

	public void setUsed(Boolean used) {
		this.used = used;
	}

	public Boolean getUsable() {
		return usable;
	}

	public void setUsable(Boolean usable) {
		this.usable = usable;
	}

	public Boolean getExpired() {
		return expired;
	}

	public void setExpired(Boolean expired) {
		this.expired = expired;
	}

	public CouponTypeVO getType() {
		return type;
	}

	public void setType(CouponTypeVO type) {
		this.type = type;
	}

	public BigDecimal getThreshold() {
		return threshold;
	}

	public void setThreshold(BigDecimal threshold) {
		this.threshold = threshold;
	}

	public String getThresholdDesc() {
		return thresholdDesc;
	}

	public void setThresholdDesc(String thresholdDesc) {
		this.thresholdDesc = thresholdDesc;
	}

	public BigDecimal getDiscount() {
		return discount;
	}

	public void setDiscount(BigDecimal discount) {
		this.discount = discount;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getPartnerLogo() {
		return partnerLogo;
	}

	public void setPartnerLogo(String partnerLogo) {
		this.partnerLogo = partnerLogo;
	}

	@Override
	public String toString() {
		final StringBuffer sb = new StringBuffer("CouponVO{");
		sb.append("id=").append(id);
		sb.append(", type=").append(type);
		sb.append(", title='").append(title).append('\'');
		sb.append(", description='").append(description).append('\'');
		sb.append(", startTime=").append(startTime);
		sb.append(", createTime=").append(createTime);
		sb.append(", expireTime=").append(expireTime);
		sb.append(", productDesc='").append(productDesc).append('\'');
		sb.append(", threshold=").append(threshold);
		sb.append(", thresholdDesc='").append(thresholdDesc).append('\'');
		sb.append(", discount=").append(discount);
		sb.append(", note='").append(note).append('\'');
		sb.append(", used=").append(used);
		sb.append(", usable=").append(usable);
		sb.append(", expired=").append(expired);
		sb.append(", code='").append(code).append('\'');
		sb.append(", partnerLogo='").append(partnerLogo).append('\'');
		sb.append(", discountRatio='").append(discountRatio).append('\'');
		sb.append('}');
		return sb.toString();
	}

	public static enum CouponTypeVO implements Type, Serializable {
		COUPON(0, "优惠券"), CARD(1, "卡券"), OFFLINE(2, "线下优惠券"), GENERAL(3, "通用优惠券");

		public final int id;
		public final String name;

		private CouponTypeVO(int id, String name) {
			this.id = id;
			this.name = name;
		}

		@Override
		public Integer getId() {
			return id;
		}

		@Override
		public String getName() {
			return name;
		}
	}

}
