package com.thebeastshop.support.mark;

import java.util.Comparator;

/**
 * 实现本接口意味着拥有enabled属性。
 *
 * @author Liang Wenjian
 */
public interface Able {

    String PROPERTY_NAME = "able";

    /**
     * 获取enabled属性的值。
     *
     * @return
     */
    boolean isEnabled();

    Comparator<Able> ABLE_ASC = new Comparator<Able>() {
		@Override
		public int compare(Able o1, Able o2) {
			return Boolean.valueOf(o1.isEnabled()).compareTo(o2.isEnabled());
		}
	};

    Comparator<Able> ABLE_DESC = new Comparator<Able>() {
		@Override
		public int compare(Able o1, Able o2) {
			return Boolean.valueOf(o2.isEnabled()).compareTo(o1.isEnabled());
		}
	};;
}
