/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.Type;

/**
 * 物流类型
 * 
 * @author Paul-xiong
 *
 */
public enum  LogisticsType implements Type {
    SHOP(1, "店送", ""),
    FEDEX(2, "联邦", "800-888-9818"),
    SF_AIR(3, "顺丰空运", "95338"),
    SF_LAND(4, "顺丰陆运", "95338"),
    YT(5, "圆通", ""),
    DEPPON(6, "德邦", ""),
    HT(7, "海淘顺丰", ""),
    SELF(8, "自送", ""),
    ZT(9, "中通", "95311")
    ;

    public final int id;
    public final String name;
    public final String tel;

    LogisticsType(final int id, final String name,final String tel) {
        this.id = id;
        this.name = name;
        this.tel = tel;
    }

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

	public String getTel() {
		return tel;
	}

}

