package com.thebeastshop.support.enums.Customize;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;

import java.util.List;
import java.util.regex.Pattern;

/**
 * 支持类型(0:小写字母 1:大写字母 2:数字 3:表情）
 * Created by GFL on 2017/5/15.
 */
public enum LimitType {

    LOWER("0", "小写字母","a-z"),
    UPPER("1", "大写字母","A-Z"),
    NUMBER("2", "数字","0-9"),
    HEART_SYMBOL("3", "爱心表情","(\\[\\[love\\]\\])*"),
    POINT_SYMBOL("4","英文点字符","."),
    SMILE_SYMBOL("5", "笑脸表情","(\\[\\[smile\\]\\])*"),
    ARROW_HEART_SYMBOL("6", "一箭穿心表情","(\\[\\[arrowheart\\]\\])*"),
    ;

    private String code;
    private String value;
    private String regEx;

    private LimitType(String code, String value,String regEx) {
        this.code = code;
        this.value = value;
        this.regEx = regEx;
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    public String getRegEx() {
        return regEx;
    }

    /**
     * 根据Code获取枚举
     * @param code
     * @return
     */
    public static LimitType getLimitTypeByCode(String code){
        for(LimitType value : LimitType.values()){
            if(StringUtils.equals(value.getCode(),code)){
                return value;
            }
        }
        return null;
    }

    /**
     * 根据Code获取枚举
     * @param codes
     * @return
     */
    public static List<LimitType> getLimitTypeByCodes(List<String> codes){
        if(null == codes){
            return  null;
        }
        List<LimitType> limitTypes = Lists.newArrayList();
        for(String code : codes){
            LimitType limitType = getLimitTypeByCode(code);
            if(null != limitType){
                limitTypes.add(limitType);
            }
        }
        return limitTypes;
    }

    public static String getRegEx(List<LimitType> limitTypes){
        boolean isHeartSymbol = false;
        boolean isSmileSymbol = false;
        boolean isArrowHeartSymbol = false;
        StringBuffer regEx = new StringBuffer();
        StringBuffer regEx1 = new StringBuffer();
        for(LimitType limitType : limitTypes){
            if(LimitType.HEART_SYMBOL.equals(limitType)){
                isHeartSymbol = true;
            }else if(LimitType.SMILE_SYMBOL.equals(limitType)){
                isSmileSymbol = true;
            }else if(LimitType.ARROW_HEART_SYMBOL.equals(limitType)){
                isArrowHeartSymbol = true;
            }else{
                regEx1.append(limitType.getRegEx());
            }
        }
        if(StringUtils.isNotEmpty(regEx1)){
            regEx1.insert(0,"[");
            regEx1.append("]*");
        }
        regEx.append("^(");
        regEx.append(regEx1);
        if(isHeartSymbol){
            regEx.append(LimitType.HEART_SYMBOL.getRegEx());
        }
        if(isSmileSymbol){
            regEx.append(LimitType.SMILE_SYMBOL.getRegEx());
        }
        if(isArrowHeartSymbol){
            regEx.append(LimitType.ARROW_HEART_SYMBOL.getRegEx());
        }
        regEx.append(")*$");
        return regEx.toString();
    }

}
