package com.thebeastshop.support.enums.Customize;

import com.google.common.collect.Lists;
import com.thebeastshop.support.enums.flowerMonth.DeliveryTimeEnum;

/**
 * Created by feilong.gao on 2017/2/17.
 */
public enum  FlowerCustomizeType {

    DELIVERY_DISTRICT(1L,"送到哪"),
    FIRST_GIFT(2L,"首单赠花瓶"),
    BARTER_BUY(3L,"换购");


    private Long code;

    private String desc;



    FlowerCustomizeType(Long code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Long getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据Code获取描述
     * @param code
     * @return
     */
    public static String getDesc(Integer code){
        for(FlowerCustomizeType value : FlowerCustomizeType.values()){
            if(value.getCode().equals(code)){
                return value.getDesc();
            }
        }
        return "";
    }
}
