/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class BeanUtil {
    public static <T> T map2Bean(Map<String, ?> map, Class<T> clazz) throws Exception {
        PropertyDescriptor[] propertys;
        T t = clazz.newInstance();
        BeanInfo beanInfo = Introspector.getBeanInfo(t.getClass());
        PropertyDescriptor[] propertyDescriptorArray = propertys = beanInfo.getPropertyDescriptors();
        int n = propertys.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor property = propertyDescriptorArray[n2];
            String key = property.getName();
            if (map.containsKey(key)) {
                Object value = map.get(key);
                Method setter = property.getWriteMethod();
                setter.invoke(t, value);
            }
            ++n2;
        }
        return t;
    }

    public static Map<String, Object> bean2Map(Object obj) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet<Field> fields = new HashSet<Field>();
        Class<?> clazz = obj.getClass();
        while (clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        for (Field field : fields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(obj));
        }
        return map;
    }

    public static <T> T buildFrom(T src, Class<T> clz) {
        return BeanUtil.buildFrom(src, clz, null);
    }

    public static <T> T buildFrom(T src, Class<T> clz, String[] ignoreProperties) {
        if (src == null) {
            return null;
        }
        T obj = null;
        try {
            obj = clz.newInstance();
            BeanUtils.copyProperties(src, obj, (String[])ignoreProperties);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz) {
        return BeanUtil.buildListFrom(src, clz, null);
    }

    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz, String[] ignoreProperties) {
        if (CollectionUtils.isEmpty(src)) {
            return Collections.emptyList();
        }
        ArrayList<T> objs = new ArrayList<T>(src.size());
        try {
            for (Object o : src) {
                T obj = clz.newInstance();
                BeanUtils.copyProperties(o, obj, (String[])ignoreProperties);
                objs.add(obj);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return objs;
    }
}

