/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.encode;

import com.thebeastshop.support.encode.Encodes;
import com.thebeastshop.support.exception.UnknownException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtil {
    public static String sha512ToString(String source) {
        return HashUtil.getString(HashUtil.sha512ToBytes(source));
    }

    public static String sha256ToString(String source) {
        return HashUtil.getString(HashUtil.sha256ToBytes(source));
    }

    public static String sha1ToString(String source) {
        return HashUtil.getString(HashUtil.sha1ToBytes(source));
    }

    public static String md5ToString(String source) {
        return HashUtil.getString(HashUtil.md5ToBytes(source));
    }

    public static String getString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            int i = element & 0xFF;
            if (i < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(i));
            ++n2;
        }
        return sb.toString();
    }

    public static byte[] sha512ToBytes(String source) {
        return HashUtil.hashToBytesCatchingException(source, "sha-512");
    }

    public static byte[] sha256ToBytes(String source) {
        return HashUtil.hashToBytesCatchingException(source, "sha-256");
    }

    public static byte[] sha1ToBytes(String source) {
        return HashUtil.hashToBytesCatchingException(source, "sha1");
    }

    public static byte[] md5ToBytes(String source) {
        return HashUtil.hashToBytesCatchingException(source, "md5");
    }

    private static byte[] hashToBytesCatchingException(String source, String algorithm) {
        try {
            return HashUtil.hashToBytes(source, algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnknownException("\u4e0d\u652f\u6301" + algorithm + "\u8fd9\u4e2a\u7b97\u6cd5", e);
        }
    }

    public static byte[] hashToBytes(String source, String algorithm) throws NoSuchAlgorithmException {
        return HashUtil.hashToBytes(source.getBytes(Encodes.UTF8.charset()), algorithm);
    }

    public static byte[] hashToBytes(byte[] source, String algorithm) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(algorithm).digest(source);
    }

    public static void main(String ... args) {
        String s = "123456";
        System.out.println(HashUtil.md5ToString("123456"));
        System.out.println(HashUtil.sha1ToString("123456"));
        System.out.println(HashUtil.sha256ToString("123456"));
        System.out.println(HashUtil.sha512ToString("123456"));
    }

    private HashUtil() {
    }
}

