/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.coll;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class SeqList
extends AbstractList<Integer>
implements Serializable,
List<Integer>,
RandomAccess {
    private static final long serialVersionUID = 1030236818265112075L;
    private final int from;
    private final int step;
    private final int size;
    private final int end;

    public SeqList(int from, int step, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0,it's " + size);
        }
        if (step <= 0) {
            throw new IllegalArgumentException("step <= 0,it's " + step);
        }
        this.step = step;
        this.size = size;
        this.from = from;
        this.end = size < 1 ? from : from + step * (size - 1);
        if (step > 0 && this.end < from || step < 0 && this.end > from) {
            throw new IllegalArgumentException("overflow,check the from,step,size");
        }
    }

    public SeqList(int from, int size) {
        this(from, 1, size);
    }

    @Override
    public Integer get(int index) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.from + index * this.step;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (o instanceof Integer) {
            int i = (Integer)o;
            return this.from <= i && i <= this.end && (this.step == 1 || (i - this.from) % this.step == 0);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        if (o != null && !this.isEmpty() && o instanceof Integer) {
            int i = (Integer)o;
            int sub = i - this.from;
            if (this.step == 1) {
                return sub;
            }
            int r = sub / this.step;
            if (r * this.step == sub) {
                return r;
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size < 1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public List<Integer> subList(int fromIndex, int toIndex) {
        return new SeqList(this.get(fromIndex), this.step, toIndex - fromIndex);
    }

    @Override
    public Object[] toArray() {
        Integer[] is = new Integer[this.size];
        return this.toArray0(is);
    }

    private Integer[] toArray0(Integer ... is) {
        int i = 0;
        while (i < this.size) {
            is[i] = this.from + this.step * i;
            ++i;
        }
        return is;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a instanceof Integer[]) {
            return a.length >= this.size ? this.toArray0((Integer[])a) : this.toArray();
        }
        throw new ClassCastException();
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < this.size) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.get(i));
            ++i;
        }
        return sb.append("]").toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.from;
        result = 31 * result + this.size;
        result = 31 * result + this.step;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        int size = this.size();
        if (size != other.size()) {
            return false;
        }
        if (other instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (!this.get(i).equals(other.get(i))) {
                    return false;
                }
                ++i;
            }
        } else {
            Iterator it = other.iterator();
            for (Object o : this) {
                if (o.equals(it.next())) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String ... args) {
        SeqList l = new SeqList(1, 1, 10);
        System.out.println(l);
        System.out.println(l.indexOf(1));
        System.out.println(l.lastIndexOf(1));
        List<Integer> l2 = new SeqList(-1, -1, 10).subList(1, 6);
        System.out.println(l2);
        ArrayList<Integer> list = new ArrayList<Integer>(l2);
        System.out.println(l2.equals(list));
    }
}

