/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.util;

import com.thebeastshop.support.encode.Base64Util;
import com.thebeastshop.support.encode.RSAUtil;
import com.thebeastshop.support.util.BeanUtil;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RSASignUtil {
    private static final String SIGN_TYPE_RSA = "RSA";
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";

    public static String getSignContent(Map<String, ?> sortedParams) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = sortedParams.get(key);
            if (!StringUtils.isNotBlank((CharSequence)key) || value == null || value.equals("")) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }

    public static String getSignContent(Object obj) throws Exception {
        Map<String, Object> sortedParams = BeanUtil.bean2Map(obj);
        return RSASignUtil.getSignContent(sortedParams);
    }

    public static String rsaSign(String content, String privateKey, String charset) throws Exception {
        PrivateKey priKey = RSAUtil.getPrivateKeyFromPKCS8(SIGN_TYPE_RSA, privateKey);
        Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
        signature.initSign(priKey);
        if (StringUtils.isEmpty((CharSequence)charset)) {
            signature.update(content.getBytes());
        } else {
            signature.update(content.getBytes(charset));
        }
        byte[] signed = signature.sign();
        return new String(Base64Util.encode(signed));
    }

    public static String rsaSign(Map<String, ?> params, String privateKey, String charset) throws Exception {
        String signContent = RSASignUtil.getSignContent(params);
        return RSASignUtil.rsaSign(signContent, privateKey, charset);
    }

    public static String rsaSign(Object obj, String privateKey, String charset) throws Exception {
        Map<String, Object> params = BeanUtil.bean2Map(obj);
        return RSASignUtil.rsaSign(params, privateKey, charset);
    }

    public static boolean rsaCheckSign(String content, String sign, String publicKey, String charset) throws Exception {
        PublicKey pubKey = RSAUtil.getPublicKeyFromX509(SIGN_TYPE_RSA, publicKey);
        Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
        signature.initVerify(pubKey);
        if (StringUtils.isEmpty((CharSequence)charset)) {
            signature.update(content.getBytes());
        } else {
            signature.update(content.getBytes(charset));
        }
        return signature.verify(Base64Util.decode(new String(sign.getBytes())));
    }
}

