/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.exception;

import com.thebeastshop.support.exception.BaseException;
import java.util.Collection;

public class WrongStateException
extends BaseException {
    private static final String STATE_NAME_PLACEHOLDER = "{STATE_NAME_PLACEHOLDER}";
    private static final String ACTUAL_STATE_PLACEHOLDER = "{ACTUAL_STATE_PLACEHOLDER}";
    private static final String DEFAULT_MSG = "\u201c{STATE_NAME_PLACEHOLDER}\u201d\u5f53\u524d\u72b6\u6001\u201c{ACTUAL_STATE_PLACEHOLDER}\u201d\u4e0d\u5bf9\u3002";
    private static final long serialVersionUID = 74075162838530489L;
    private String code;
    private final String stateName;
    private final Object actualState;

    protected static String replaceParams(String stateName, Object actualState) {
        return WrongStateException.replaceParams(DEFAULT_MSG, stateName, actualState);
    }

    protected static String replaceParams(String msgTemplate, String stateName, Object actualState) {
        return msgTemplate.replace(STATE_NAME_PLACEHOLDER, stateName).replace(ACTUAL_STATE_PLACEHOLDER, String.valueOf(actualState));
    }

    public WrongStateException(String stateName, Object actualState) {
        super(WrongStateException.replaceParams(stateName, actualState), NEXT_STEP_IDS_OF_RETRY);
        this.stateName = stateName;
        this.actualState = actualState;
    }

    public WrongStateException(String message, String stateName, Object actualState) {
        super(message, NEXT_STEP_IDS_OF_RETRY);
        this.stateName = stateName;
        this.actualState = actualState;
    }

    public WrongStateException(String code, String message, String stateName, Object actualState) {
        super(message, NEXT_STEP_IDS_OF_RETRY, code);
        this.stateName = stateName;
        this.actualState = actualState;
        this.code = code;
    }

    public WrongStateException(Throwable cause, String stateName, Object actualState) {
        this(WrongStateException.replaceParams(stateName, actualState), cause, stateName, actualState);
    }

    public WrongStateException(String message, Throwable cause, String stateName, Object actualState) {
        super(message, cause, NEXT_STEP_IDS_OF_RETRY);
        this.stateName = stateName;
        this.actualState = actualState;
    }

    public WrongStateException(Throwable cause, Collection<String> nextStepIds, String stateName, Object actualState) {
        super(WrongStateException.replaceParams(stateName, actualState), cause, nextStepIds);
        this.stateName = stateName;
        this.actualState = actualState;
    }

    public WrongStateException(String message, Throwable cause, Collection<String> nextStepIds, String stateName, Object actualState) {
        super(message, cause, nextStepIds);
        this.stateName = stateName;
        this.actualState = actualState;
    }

    public WrongStateException(String message, Collection<String> nextStepIds, String stateName, Object actualState) {
        super(message, nextStepIds);
        this.stateName = stateName;
        this.actualState = actualState;
    }

    public String getStateName() {
        return this.stateName;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.hashCode() + ":{" + "stateName:'" + this.stateName + '\'' + ", actualState:" + this.actualState + '}';
    }

    public Object getActualState() {
        return this.actualState;
    }
}

