/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.exception;

import com.thebeastshop.support.exception.BaseException;
import java.util.concurrent.TimeUnit;

public class TooManyRequestsException
extends BaseException {
    public static final String TIME_UNIT_PLACEHOLDER = "{TIME_UNIT_PLACEHOLDER}";
    public static final String LIMIT_TIMES_PLACEHOLDER = "{LIMIT_TIMES_PLACEHOLDER}";
    public static final String DEFAULT_MSG = "\u5728\u4e00{TIME_UNIT_PLACEHOLDER}\u65f6\u95f4\u5185\u8bf7\u6c42\u6b21\u6570\u4e0d\u5141\u8bb8\u8d85\u8fc7{LIMIT_TIMES_PLACEHOLDER}\u6b21\u3002";
    public static final String DEFAULT_LIMIT_TIMES_STR = "\u9650\u5b9a";
    public static final String DEFAULT_TIME_UNIT_STR = "\u6bb5";
    private static final long serialVersionUID = 8709388432888732021L;
    private final TimeUnit timeUnit;
    private final Integer limitTimes;

    public TooManyRequestsException() {
        super(TooManyRequestsException.buildDefaultMsg(DEFAULT_TIME_UNIT_STR, DEFAULT_LIMIT_TIMES_STR));
        this.timeUnit = null;
        this.limitTimes = null;
    }

    public TooManyRequestsException(TimeUnit timeUnit, Integer limitTimes) {
        this(TooManyRequestsException.buildDefaultMsg(timeUnit, limitTimes), timeUnit, limitTimes);
    }

    public TooManyRequestsException(String message, TimeUnit timeUnit, Integer limitTimes) {
        super(message, NEXT_STEP_IDS_OF_RETRY_OR_REPORT_BUG);
        this.limitTimes = limitTimes;
        this.timeUnit = timeUnit;
    }

    public TooManyRequestsException(Throwable cause, TimeUnit timeUnit, Integer limitTimes) {
        this(TooManyRequestsException.buildDefaultMsg(timeUnit, limitTimes), cause, timeUnit, limitTimes);
    }

    public TooManyRequestsException(String message, Throwable cause, TimeUnit timeUnit, Integer limitTimes) {
        super(message, cause, NEXT_STEP_IDS_OF_RETRY_OR_REPORT_BUG);
        this.limitTimes = limitTimes;
        this.timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Integer getLimitTimes() {
        return this.limitTimes;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.hashCode() + ":{" + "limitTimes:" + this.limitTimes + ", timeUnit:" + (Object)((Object)this.timeUnit) + '}';
    }

    public static String buildDefaultMsg(TimeUnit timeUnit, Integer limitTimes) {
        return TooManyRequestsException.buildDefaultMsg(timeUnit.toString(), limitTimes == null ? DEFAULT_LIMIT_TIMES_STR : String.valueOf(limitTimes));
    }

    public static String buildDefaultMsg(String timeUnitStr, String limitTimesStr) {
        return DEFAULT_MSG.replace(TIME_UNIT_PLACEHOLDER, timeUnitStr).replace(LIMIT_TIMES_PLACEHOLDER, limitTimesStr);
    }
}

