/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.encode;

import com.thebeastshop.support.encode.Encodes;
import com.thebeastshop.support.exception.UnknownException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    public static final String MD5 = "MD5";

    public static byte[] md5ToBytes(String source, Encodes encodes) throws IllegalArgumentException {
        try {
            MessageDigest md = MessageDigest.getInstance(MD5);
            return md.digest(source.getBytes(encodes.getName()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnknownException("\u4e0d\u652f\u6301MD5\u8fd9\u4e2a\u7b97\u6cd5\uff0c\u4e0d\u53ef\u80fd", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnknownException("\u4e0d\u652f\u6301" + (Object)((Object)encodes) + "\uff0c\u4e0d\u53ef\u80fd", e);
        }
    }

    public static byte[] md5ToBytes(String source) throws IllegalArgumentException {
        return MD5Util.md5ToBytes(source, Encodes.UTF8);
    }

    public static String md5ToHexString(String source, Encodes encodes) throws IllegalArgumentException {
        byte[] b = MD5Util.md5ToBytes(source, encodes);
        StringBuilder sb = new StringBuilder();
        for (byte element : b) {
            int i = element & 0xFF;
            if (i < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(i));
        }
        return sb.toString();
    }

    public static String md5ToHexString(String source) throws IllegalArgumentException {
        return MD5Util.md5ToHexString(source, Encodes.UTF8);
    }
}

