/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support.vo.order;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import com.google.common.collect.Lists;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;
import com.thebeastshop.support.vo.logistics.DateUnitVO;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.logistics.TimeSlotVO;
import com.thebeastshop.support.vo.member.MemberAddressVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;

/**
 * 预览订单
 * 
 * @author Paul-xiong
 *
 */
public class OrderConfirmVO implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 礼品卡
	 */
	private List<GiftCardVO> giftCards;

	/**
	 * 价格
	 */
	private BigDecimal price;

	/**
	 * 定制费用
	 */
	private BigDecimal charge;
	/**
	 * 商品包
	 */
	private Collection<CartProductPackVO> packs = Lists.newArrayList();
	/**
	 * 标签
	 */
	private Collection<Label> labels = Lists.newArrayList();
	/**
	 * 是否包含海外购商品
	 */
	private boolean hasOverseaProducts = false;
	/**
	 * 价格步骤
	 */
	private Collection<PriceStepVO> priceSteps;
	/**
	 * 地址信息
	 */
	private MemberAddressVO address;
	/**
	 * 配送描述
	 */
	private String deliveryTip;
	/**
	 * 可配送日期
	 */
	private List<DateUnitVO> deliverableDates;
	/**
	 * 时段
	 */
	private List<TimeSlotVO> deliverableTimeSlots;
	/**
	 * 邮费
	 */
	private PostageVO postage;
	/**
	 * 是否可以使用生日折扣
	 */
	private BdayVO bday;
	/**
	 * 可用的支付方式
	 */
	private List<PaymentType> payMethods;

	/**
	 * 是否可以添加备注
	 */
	private Boolean canRemark;

	/**
	 * 订单业务类型
	 */
	private OrderBusinessType orderType = OrderBusinessType.NORMAL;

	/**
	 * 是否包含定制
	 */
	private Boolean customizable = Boolean.FALSE;

	/**
	 * 是否允许使用语音卡
	 */
	private Boolean voiceCard = Boolean.TRUE;
	
	/**
	 * 是否允许提交
	 */
	private Boolean canSubmit = Boolean.TRUE;

	public List<GiftCardVO> getGiftCards() {
		return giftCards;
	}

	public void setGiftCards(List<GiftCardVO> giftCards) {
		this.giftCards = giftCards;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public Boolean getVoiceCard() {
		return voiceCard;
	}

	public void setVoiceCard(Boolean voiceCard) {
		this.voiceCard = voiceCard;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public Collection<CartProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(Collection<CartProductPackVO> packs) {
		this.packs = packs;
	}

	public boolean isHasOverseaProducts() {
		return hasOverseaProducts;
	}

	public void setHasOverseaProducts(boolean hasOverseaProducts) {
		this.hasOverseaProducts = hasOverseaProducts;
	}

	public Collection<PriceStepVO> getPriceSteps() {
		return priceSteps;
	}

	public void setPriceSteps(Collection<PriceStepVO> priceSteps) {
		this.priceSteps = priceSteps;
	}

	public MemberAddressVO getAddress() {
		return address;
	}

	public void setAddress(MemberAddressVO address) {
		this.address = address;
	}

	public String getDeliveryTip() {
		return deliveryTip;
	}

	public void setDeliveryTip(String deliveryTip) {
		this.deliveryTip = deliveryTip;
	}

	public List<DateUnitVO> getDeliverableDates() {
		return deliverableDates;
	}

	public void setDeliverableDates(List<DateUnitVO> deliverableDates) {
		this.deliverableDates = deliverableDates;
	}

	public List<TimeSlotVO> getDeliverableTimeSlots() {
		return deliverableTimeSlots;
	}

	public void setDeliverableTimeSlots(List<TimeSlotVO> deliverableTimeSlots) {
		this.deliverableTimeSlots = deliverableTimeSlots;
	}

	public BdayVO getBday() {
		return bday;
	}

	public void setBday(BdayVO bday) {
		this.bday = bday;
	}

	public Collection<Label> getLabels() {
		return labels;
	}

	public void setLabels(Collection<Label> labels) {
		this.labels = labels;
	}

	public PostageVO getPostage() {
		return postage;
	}

	public void setPostage(PostageVO postage) {
		this.postage = postage;
	}

	public List<PaymentType> getPayMethods() {
		return payMethods;
	}

	public void setPayMethods(List<PaymentType> payMethods) {
		this.payMethods = payMethods;
	}

	public Boolean getCanRemark() {
		return canRemark;
	}

	public void setCanRemark(Boolean canRemark) {
		this.canRemark = canRemark;
	}

	public BigDecimal getCharge() {
		return charge;
	}

	public void setCharge(BigDecimal charge) {
		this.charge = charge;
	}

	public OrderBusinessType getOrderType() {
		return orderType;
	}

	public void setOrderType(OrderBusinessType orderType) {
		this.orderType = orderType;
	}

	public Boolean getCustomizable() {
		return customizable;
	}

	public void setCustomizable(Boolean customizable) {
		this.customizable = customizable;
	}
	
	public Boolean getCanSubmit() {
		return canSubmit;
	}

	public void setCanSubmit(Boolean canSubmit) {
		this.canSubmit = canSubmit;
	}

	@Override
	public String toString() {
		final StringBuffer sb = new StringBuffer("OrderConfirmVO{");
		sb.append("price=").append(price);
		sb.append(", charge=").append(charge);
		sb.append(", packs=").append(packs);
		sb.append(", labels=").append(labels);
		sb.append(", hasOverseaProducts=").append(hasOverseaProducts);
		sb.append(", priceSteps=").append(priceSteps);
		sb.append(", address=").append(address);
		sb.append(", deliveryTip='").append(deliveryTip).append('\'');
		sb.append(", deliverableDates=").append(deliverableDates);
		sb.append(", deliverableTimeSlots=").append(deliverableTimeSlots);
		sb.append(", postage=").append(postage);
		sb.append(", bday=").append(bday);
		sb.append(", payMethods=").append(payMethods);
		sb.append(", canRemark=").append(canRemark);
		sb.append(", orderType=").append(orderType);
		sb.append(", customizable=").append(customizable);
		sb.append(", voiceCard=").append(voiceCard);
		sb.append(", canSubmit=").append(canSubmit);
		sb.append('}');
		return sb.toString();
	}

	/**
	 * 生日折扣
	 * 
	 * @author Paul-xiong
	 *
	 */
	public static class BdayVO implements Serializable {

		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		/**
		 * 是否在生日折扣可以使用的期间内
		 */
		private boolean within;
		/**
		 * 今年是否已经使用过
		 */
		private boolean used;
		/**
		 * 折扣率
		 */
		private BigDecimal ratio;

		public boolean isWithin() {
			return within;
		}

		public void setWithin(boolean within) {
			this.within = within;
		}

		public boolean isUsed() {
			return used;
		}

		public void setUsed(boolean used) {
			this.used = used;
		}

		public BigDecimal getRatio() {
			return ratio;
		}

		public void setRatio(BigDecimal ratio) {
			this.ratio = ratio;
		}

		@Override
		public String toString() {
			return "BdayVO [within=" + within + ", used=" + used + ", ratio=" + ratio + "]";
		}

	}

}
