package com.thebeastshop.support.vo.order;

import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.cps.CpsInfo;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;
import com.thebeastshop.support.vo.logistics.PostageVO;

/**
 * 确认订单DTO
 * 
 * @author Paul-xiong
 *
 */
public class OrderConfirmDTO {
	/**
	 * 商品包
	 */
	private List<RequestPack> packs;
	/**
	 * 地址id
	 */
	private long addressId;
	/**
	 * 配送日期
	 */
	private String deliveryDate;
	
	/**
	 * 配送类型:(0: 配送方式~非快递（自提）,1快递）
	 */
	private Integer deliveryType;
	/**
	 * 配送时段
	 */
	private int deliveryTimeSlot;
	
	/**
	 * 配送时段
	 */
	private String deliveryTime;
	/**
	 * IPOS 运费
	 */
	private PostageVO postage;

	/**
	 * IPOS 发票id
	 */
	private String invoiceId;
	/**
	 * 卡片
	 */
	private String card;
	/**
	 * 新卡片
	 */
	private OrderCard newCard;
	/**
	 * 优惠券id
	 */
	private Long couponId;
	/**
	 * 是否为匿名购买
	 */
	private boolean anonymous = true;
	/**
	 * 是否使用生日折扣
	 */
	private boolean useBdayDiscount = false;
	/**
	 * 支付金额
	 */
	private BigDecimal price;
	/**
	 * APP下载来源
	 */
	private String downloadSource;

	/**
	 * 订单备注
	 */
	private String remark;

	/**
	 * 订单业务类型
	 */
	private OrderBusinessType orderType = OrderBusinessType.NORMAL;
	
	/**
	 * 礼品卡
	 */
	private List<GiftCardVO> giftCards;
	
	/**
	 * 第三方
	 */
	private CpsInfo cpsInfo;

	/**
	 *
	 * 配送运费
	 */
	private BigDecimal deliveryPrice;
	
    /**
     * 投入来源
     */
    private String utmSource; 
    
	/**
	 * 操作员Id
	 */
	private Long createOperatorId;
	/**
	 * 操作员名称
	 */
	private String createOperatorName;

	public List<RequestPack> getPacks() {
		return packs;
	}

	public void setPacks(List<RequestPack> packs) {
		this.packs = packs;
	}

	public long getAddressId() {
		return addressId;
	}

	public void setAddressId(long addressId) {
		this.addressId = addressId;
	}

	public String getDeliveryDate() {
		return deliveryDate;
	}

	public void setDeliveryDate(String deliveryDate) {
		this.deliveryDate = deliveryDate;
	}

	public int getDeliveryTimeSlot() {
		return deliveryTimeSlot;
	}

	public void setDeliveryTimeSlot(int deliveryTimeSlot) {
		this.deliveryTimeSlot = deliveryTimeSlot;
	}

	public PostageVO getPostage() {
		return postage;
	}

	public void setPostage(PostageVO postage) {
		this.postage = postage;
	}

	public String getInvoiceId() {
		return invoiceId;
	}

	public void setInvoiceId(String invoiceId) {
		this.invoiceId = invoiceId;
	}

	public String getCard() {
		return card;
	}

	public void setCard(String card) {
		this.card = card;
	}

	public OrderCard getNewCard() {
		return newCard;
	}

	public void setNewCard(OrderCard newCard) {
		this.newCard = newCard;
	}

	public boolean isAnonymous() {
		return anonymous;
	}

	public void setAnonymous(boolean anonymous) {
		this.anonymous = anonymous;
	}

	public boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public String getDownloadSource() {
		return downloadSource;
	}

	public void setDownloadSource(String downloadSource) {
		this.downloadSource = downloadSource;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public OrderBusinessType getOrderType() {
		return orderType;
	}

	public void setOrderType(OrderBusinessType orderType) {
		this.orderType = orderType;
	}

	public CpsInfo getCpsInfo() {
		return cpsInfo;
	}

	public void setCpsInfo(CpsInfo cpsInfo) {
		this.cpsInfo = cpsInfo;
	}

	public List<GiftCardVO> getGiftCards() {
		return giftCards;
	}

	public void setGiftCards(List<GiftCardVO> giftCards) {
		this.giftCards = giftCards;
	}

	public BigDecimal getDeliveryPrice() {
		return deliveryPrice;
	}

	public void setDeliveryPrice(BigDecimal deliveryPrice) {
		this.deliveryPrice = deliveryPrice;
	}

	public String getUtmSource() {
		return utmSource;
	}

	public void setUtmSource(String utmSource) {
		this.utmSource = utmSource;
	}

	public Integer getDeliveryType() {
		return deliveryType;
	}

	public void setDeliveryType(Integer deliveryType) {
		this.deliveryType = deliveryType;
	}

	public Long getCreateOperatorId() {
		return createOperatorId;
	}

	public void setCreateOperatorId(Long createOperatorId) {
		this.createOperatorId = createOperatorId;
	}

	public String getCreateOperatorName() {
		return createOperatorName;
	}

	public void setCreateOperatorName(String createOperatorName) {
		this.createOperatorName = createOperatorName;
	}

	public String getDeliveryTime() {
		return deliveryTime;
	}

	public void setDeliveryTime(String deliveryTime) {
		this.deliveryTime = deliveryTime;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
	}
}
