package com.thebeastshop.support.vo.giftcard;

import java.io.Serializable;
import java.math.BigDecimal;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 礼品卡VO
 * @Class Name GiftCardVO
 * @Author Xiang.Gao
 * @Create In 2017-12-27
 */
public class GiftCardVO implements Serializable{

	/**
	 * @Field long serialVersionUID 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 卡号
	 */
	private String cardNo;
	
	/**
	 * 金额
	 */
	private BigDecimal amount;
	
	/**
	 * 过期时间
	 */
	private String expireDate;
	
	public GiftCardVO() {
		super();
	}
	
	public GiftCardVO(String cardNo, BigDecimal amount, String expireDate) {
		this.cardNo = cardNo;
		this.amount = amount;
		this.expireDate = expireDate;
	}

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public String getExpireDate() {
		return expireDate;
	}

	public void setExpireDate(String expireDate) {
		this.expireDate = expireDate;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
	}
	
}	
