package com.thebeastshop.support.vo.cart;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.support.Label;
import com.thebeastshop.support.vo.announcement.AnnouncementVO;

/**
 * @author Liang Wenjian
 */
public class CartVO implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -6585821989342529298L;
	/**
	 * 公告
	 */
	private List<AnnouncementVO> announcements;
	/**
	 * 商品包
	 */
	private List<CartProductPackVO> packs;
	/**
	 * 加价购商品
	 */
	private List<CartProductPackVO> addiblePacks;
	/**
	 * 赠品商品
	 */
	private List<CartProductPackVO> giftPacks;

	/**
	 * 权益商品
	 */
	private List<CartProductPackVO> interestPacks;

	/**
	 * 购物车商品组
	 */
	private List<GroupsVO> groups;
	/**
	 * 购物车标签
	 */
	private List<Label> labels;
	/**
	 * 无效商品
	 */
	private List<CartProductPackVO> invalidPacks;
	/**
	 * 邮费
	 */
	private BigDecimal postage;
	/**
	 * 优惠金额
	 */
	private BigDecimal savedPrice;
	/**
	 * 最终价格
	 */
	private BigDecimal price;

	public CartVO() {
		super();
	}

	public List<AnnouncementVO> getAnnouncements() {
		return announcements;
	}

	public void setAnnouncements(List<AnnouncementVO> announcements) {
		this.announcements = announcements;
	}

	public List<CartProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(List<CartProductPackVO> packs) {
		this.packs = packs;
	}

	public List<CartProductPackVO> getAddiblePacks() {
		return addiblePacks;
	}

	public void setAddiblePacks(List<CartProductPackVO> addiblePacks) {
		this.addiblePacks = addiblePacks;
	}

	public List<CartProductPackVO> getGiftPacks() {
		return giftPacks;
	}

	public void setGiftPacks(List<CartProductPackVO> giftPacks) {
		this.giftPacks = giftPacks;
	}

	public List<CartProductPackVO> getInterestPacks() {
		return interestPacks;
	}

	public void setInterestPacks(List<CartProductPackVO> interestPacks) {
		this.interestPacks = interestPacks;
	}

	public List<GroupsVO> getGroups() {
		return groups;
	}

	public void setGroups(List<GroupsVO> groups) {
		this.groups = groups;
	}

	public List<Label> getLabels() {
		return labels;
	}

	public void setLabels(List<Label> labels) {
		this.labels = labels;
	}

	public List<CartProductPackVO> getInvalidPacks() {
		return invalidPacks;
	}

	public void setInvalidPacks(List<CartProductPackVO> invalidPacks) {
		this.invalidPacks = invalidPacks;
	}

	public BigDecimal getPostage() {
		return postage;
	}

	public void setPostage(BigDecimal postage) {
		this.postage = postage;
	}

	public BigDecimal getSavedPrice() {
		return savedPrice;
	}

	public void setSavedPrice(BigDecimal savedPrice) {
		this.savedPrice = savedPrice;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder("CartVO{");
		sb.append("announcements=").append(announcements);
		sb.append(", packs=").append(packs);
		sb.append(", addiblePacks=").append(addiblePacks);
		sb.append(", giftPacks=").append(giftPacks);
		sb.append(", interestPacks=").append(interestPacks);
		sb.append(", groups=").append(groups);
		sb.append(", labels=").append(labels);
		sb.append(", invalidPacks=").append(invalidPacks);
		sb.append(", postage=").append(postage);
		sb.append(", savedPrice=").append(savedPrice);
		sb.append(", price=").append(price);
		sb.append('}');
		return sb.toString();
	}
}
