package com.thebeastshop.support.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;
import com.thebeastshop.support.mark.HasName;

/**
 * 价格计算类型
 * 
 * @author Paul-xiong
 *
 */
public enum PriceType implements HasIntIdGetter,HasName {
	MEMBER_LEVEL(1, "会员折扣"), 
	CAMPAIGN(2, "活动"), 
	COUPON(3, "优惠券"), 
	BIRTHDAY(4, "生日折扣"), 
	GIFTCARD(5, "礼品卡"), 
	POSTAGE(6, "运费"), 
	OVERSEAS(7, "海淘运费"), 
	CUSTOMIZE(8, "定制费"), 
	TIME(9, "精确时段配送费"), 
	PSD(10, "浦发权益兑换"), 
	JBR(11, "圣诞集赞"), 
	POINT(12, "积分兑换"), 
    REMOTE_AREA_DELIVERY(20, "偏远地区配送费"),
	INTEREST_PRD_POSTAGE_FREE(30, "商品权益免运费"),
	INTEREST_MEM_POSTAGE_FREE(31,"会员权益免运费"), 
	POSTAGE_FREE(32, "实付99元免运费"), 
	OVERSEA_FREE(33, "海淘免运费"), 
	CUSTOMIZE_FREE(34, "大象会员免定制费");

	public final Integer id;
	public final String name;

	public static final List<PriceType> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PriceType(final Integer id, final String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

	public static PriceType getByCode(Integer id) {
		for (PriceType priceType : values()) {
			if (priceType.getId().equals(id)) {
				return priceType;
			}
		}
		return null;
	}

}
